/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.google.inject.Singleton;
import java.util.Objects;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class ClusterLease {
    private volatile Ownership leaseOwnership;

    public ClusterLease() {
        this(Ownership.INDETERMINATE);
    }

    public ClusterLease(Ownership leaseOwnership) {
        this.leaseOwnership = leaseOwnership;
    }

    public ScheduleDecision toScheduleDecision() {
        return this.leaseOwnership.toScheduleDecision();
    }

    public boolean isClaimedByLocalSidecar() {
        return this.leaseOwnership == Ownership.CLAIMED;
    }

    void setOwnership(Ownership ownership) {
        this.leaseOwnership = Objects.requireNonNull(ownership, "ownership must be provided");
    }

    @VisibleForTesting
    public void setOwnershipTesting(Ownership ownership) {
        this.setOwnership(ownership);
    }

    public static enum Ownership {
        CLAIMED,
        LOST,
        INDETERMINATE;


        private ScheduleDecision toScheduleDecision() {
            switch (this) {
                case CLAIMED: {
                    return ScheduleDecision.EXECUTE;
                }
                case LOST: {
                    return ScheduleDecision.SKIP;
                }
            }
            return ScheduleDecision.RESCHEDULE;
        }
    }
}

