/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.vertx.core.http.ClientAuth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.KeyStoreConfiguration;
import org.apache.cassandra.sidecar.config.SslConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfigurationImpl
implements SslConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslConfigurationImpl.class);
    public static final boolean DEFAULT_SSL_ENABLED = false;
    public static final boolean DEFAULT_USE_OPEN_SSL = true;
    public static final SecondBoundConfiguration DEFAULT_HANDSHAKE_TIMEOUT = SecondBoundConfiguration.parse((String)"10s");
    public static final String DEFAULT_CLIENT_AUTH = "NONE";
    public static final List<String> DEFAULT_SECURE_TRANSPORT_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("TLSv1.2", "TLSv1.3"));
    @JsonProperty(value="enabled")
    protected final boolean enabled;
    @JsonProperty(value="use_openssl")
    protected final boolean useOpenSsl;
    protected SecondBoundConfiguration handshakeTimeout;
    protected String clientAuth;
    @JsonProperty(value="cipher_suites")
    protected final List<String> cipherSuites;
    @JsonProperty(value="accepted_protocols")
    protected final List<String> secureTransportProtocols;
    @JsonProperty(value="keystore")
    protected final KeyStoreConfiguration keystore;
    @JsonProperty(value="truststore")
    protected final KeyStoreConfiguration truststore;

    public SslConfigurationImpl() {
        this(SslConfigurationImpl.builder());
    }

    protected SslConfigurationImpl(Builder builder) {
        this.enabled = builder.enabled;
        this.useOpenSsl = builder.useOpenSsl;
        this.handshakeTimeout = builder.handshakeTimeout;
        this.setClientAuth(builder.clientAuth);
        this.keystore = builder.keystore;
        this.truststore = builder.truststore;
        this.cipherSuites = builder.cipherSuites;
        this.secureTransportProtocols = builder.secureTransportProtocols;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="use_openssl")
    public boolean preferOpenSSL() {
        return this.useOpenSsl;
    }

    @Override
    @JsonProperty(value="handshake_timeout")
    public SecondBoundConfiguration handshakeTimeout() {
        return this.handshakeTimeout;
    }

    @JsonProperty(value="handshake_timeout")
    public void setHandshakeTimeout(SecondBoundConfiguration handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    @JsonProperty(value="handshake_timeout_sec")
    @Deprecated
    public void setHandshakeTimeoutInSeconds(long handshakeTimeoutInSeconds) {
        LOGGER.warn("'handshake_timeout_sec' is deprecated, use 'handshake_timeout' instead");
        this.setHandshakeTimeout(new SecondBoundConfiguration(handshakeTimeoutInSeconds, TimeUnit.SECONDS));
    }

    @Override
    @JsonProperty(value="client_auth")
    public String clientAuth() {
        return this.clientAuth;
    }

    @JsonProperty(value="client_auth")
    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
        try {
            this.clientAuth = ClientAuth.valueOf((String)clientAuth).name();
        }
        catch (IllegalArgumentException exception) {
            String errorMessage = String.format("Invalid client_auth configuration=\"%s\", valid values are (%s)", clientAuth, Arrays.stream(ClientAuth.values()).map(Enum::name).collect(Collectors.joining(",")));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    @JsonProperty(value="cipher_suites")
    public List<String> cipherSuites() {
        return this.cipherSuites;
    }

    @Override
    @JsonProperty(value="accepted_protocols")
    public List<String> secureTransportProtocols() {
        return this.secureTransportProtocols;
    }

    @Override
    @JsonProperty(value="keystore")
    public KeyStoreConfiguration keystore() {
        return this.keystore;
    }

    @Override
    public boolean isTrustStoreConfigured() {
        return this.truststore != null && this.truststore.isConfigured();
    }

    @Override
    @JsonProperty(value="truststore")
    public KeyStoreConfiguration truststore() {
        return this.truststore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements DataObjectBuilder<Builder, SslConfigurationImpl> {
        protected boolean enabled = false;
        protected boolean useOpenSsl = true;
        protected SecondBoundConfiguration handshakeTimeout = DEFAULT_HANDSHAKE_TIMEOUT;
        protected String clientAuth = "NONE";
        protected List<String> cipherSuites = Collections.emptyList();
        protected List<String> secureTransportProtocols = DEFAULT_SECURE_TRANSPORT_PROTOCOLS;
        protected KeyStoreConfiguration keystore = null;
        protected KeyStoreConfiguration truststore = null;

        protected Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder enabled(boolean enabled) {
            return (Builder)this.update(b -> {
                b.enabled = enabled;
            });
        }

        public Builder useOpenSsl(boolean useOpenSsl) {
            return (Builder)this.update(b -> {
                b.useOpenSsl = useOpenSsl;
            });
        }

        public Builder handshakeTimeout(SecondBoundConfiguration handshakeTimeout) {
            return (Builder)this.update(b -> {
                b.handshakeTimeout = handshakeTimeout;
            });
        }

        public Builder clientAuth(String clientAuth) {
            return (Builder)this.update(b -> {
                b.clientAuth = clientAuth;
            });
        }

        public Builder cipherSuites(List<String> cipherSuites) {
            return (Builder)this.update(b -> {
                b.cipherSuites = new ArrayList<String>(cipherSuites);
            });
        }

        public Builder secureTransportProtocols(List<String> secureTransportProtocols) {
            return (Builder)this.update(b -> {
                b.secureTransportProtocols = new ArrayList<String>(secureTransportProtocols);
            });
        }

        public Builder keystore(KeyStoreConfiguration keystore) {
            return (Builder)this.update(b -> {
                b.keystore = keystore;
            });
        }

        public Builder truststore(KeyStoreConfiguration truststore) {
            return (Builder)this.update(b -> {
                b.truststore = truststore;
            });
        }

        public SslConfigurationImpl build() {
            return new SslConfigurationImpl(this);
        }
    }
}

