/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SidecarPeerHealthConfiguration;
import org.apache.cassandra.sidecar.config.yaml.PeriodicTaskConfigurationImpl;

public class SidecarPeerHealthConfigurationImpl
extends PeriodicTaskConfigurationImpl
implements SidecarPeerHealthConfiguration {
    public static final boolean DEFAULT_ENABLED = false;
    public static final MillisecondBoundConfiguration DEFAULT_EXECUTE_INTERVAL = new MillisecondBoundConfiguration(30L, TimeUnit.SECONDS);
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final MillisecondBoundConfiguration DEFAULT_RETRY_DELAY = new MillisecondBoundConfiguration(10L, TimeUnit.SECONDS);
    @JsonProperty(value="max_retries")
    private final int maxRetries;
    @JsonProperty(value="retry_delay")
    private final MillisecondBoundConfiguration retryDelay;

    public SidecarPeerHealthConfigurationImpl() {
        super(false, DEFAULT_EXECUTE_INTERVAL, DEFAULT_EXECUTE_INTERVAL);
        this.maxRetries = 5;
        this.retryDelay = DEFAULT_RETRY_DELAY;
    }

    public SidecarPeerHealthConfigurationImpl(boolean enabled, MillisecondBoundConfiguration frequency, int maxRetries, MillisecondBoundConfiguration retryDelay) {
        super(enabled, frequency, frequency);
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
    }

    @Override
    @JsonProperty(value="max_retries")
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    @JsonProperty(value="retry_delay")
    public MillisecondBoundConfiguration retryDelay() {
        return this.retryDelay;
    }
}

