/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.concurrent;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;

@Singleton
public class ExecutorPools {
    private final TaskExecutorPool taskExecutors;
    private final TaskExecutorPool internalTaskExecutors;

    public ExecutorPools(Vertx vertx, ServiceConfiguration configuration) {
        this(vertx, configuration, null);
    }

    @Inject
    public ExecutorPools(Vertx vertx, ServiceConfiguration configuration, SidecarMetrics metrics) {
        this.taskExecutors = new TaskExecutorPool.ServiceTaskExecutorPool(vertx, configuration.serverWorkerPoolConfiguration(), metrics);
        this.internalTaskExecutors = new TaskExecutorPool.InternalTaskExecutorPool(vertx, configuration.serverInternalWorkerPoolConfiguration(), metrics);
    }

    public TaskExecutorPool service() {
        return this.taskExecutors;
    }

    public TaskExecutorPool internal() {
        return this.internalTaskExecutors;
    }

    public Future<Void> close() {
        return this.taskExecutors.closeInternal().onComplete(v -> this.internalTaskExecutors.closeInternal());
    }
}

