/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.impl.WildcardPermissionBasedAuthorizationImpl;
import java.util.Arrays;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScope;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScopes;
import org.apache.cassandra.sidecar.acl.authorization.StandardPermission;
import org.apache.cassandra.sidecar.common.utils.StringUtils;

public class DomainAwarePermission
extends StandardPermission {
    public static final String WILDCARD_TOKEN = "*";
    public static final String WILDCARD_PART_DIVIDER_TOKEN = ":";

    public DomainAwarePermission(String name) {
        this(name, ResourceScopes.NO_SCOPE);
    }

    public DomainAwarePermission(String name, ResourceScope scope) {
        super(name, scope);
        this.validate(name);
    }

    private void validate(String name) {
        if (name.contains(WILDCARD_TOKEN)) {
            throw new IllegalArgumentException("DomainAwarePermission can not have * to avoid unpredictable behavior");
        }
        if (!name.contains(WILDCARD_PART_DIVIDER_TOKEN)) {
            throw new IllegalArgumentException("DomainAwarePermission must have : to divide domain and action");
        }
        String[] wildcardParts = name.split(WILDCARD_PART_DIVIDER_TOKEN);
        boolean hasEmptyParts = Arrays.stream(wildcardParts).anyMatch(String::isEmpty);
        if (wildcardParts.length == 0 || hasEmptyParts) {
            throw new IllegalArgumentException("DomainAwarePermission parts can not be empty");
        }
    }

    @Override
    public Authorization toAuthorization(String resource) {
        WildcardPermissionBasedAuthorizationImpl authorization = new WildcardPermissionBasedAuthorizationImpl(this.name);
        if (StringUtils.isNotEmpty((String)resource)) {
            authorization.setResource(this.resourceScope.resolveWithResource(resource));
        }
        return authorization;
    }
}

