/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.RateLimiter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.atomic.AtomicReference;

public class SidecarRateLimiter {
    private final AtomicReference<RateLimiterWrapper> ref = new AtomicReference<Object>(null);

    private SidecarRateLimiter(double permitsPerSecond) {
        if (permitsPerSecond > 0.0) {
            RateLimiterWrapper rateLimiterWrapper = RateLimiterWrapper.create(permitsPerSecond);
            this.ref.set(rateLimiterWrapper);
        }
    }

    public static SidecarRateLimiter create(double permitsPerSecond) {
        return new SidecarRateLimiter(permitsPerSecond);
    }

    public long queryWaitTimeInMicros() {
        RateLimiterWrapper rateLimiterWrapper = this.ref.get();
        return rateLimiterWrapper != null ? rateLimiterWrapper.queryWaitTimeInMicros() : 0L;
    }

    public boolean tryAcquire() {
        RateLimiterWrapper rateLimiterWrapper = this.ref.get();
        return rateLimiterWrapper == null || rateLimiterWrapper.rateLimiter.tryAcquire();
    }

    public void rate(double permitsPerSecond) {
        RateLimiterWrapper rateLimiterWrapper = this.ref.get();
        if (permitsPerSecond > 0.0) {
            if (rateLimiterWrapper == null) {
                this.ref.compareAndSet(null, RateLimiterWrapper.create(permitsPerSecond));
            } else {
                rateLimiterWrapper.rateLimiter.setRate(permitsPerSecond);
            }
        } else {
            this.ref.set(null);
        }
    }

    public double rate() {
        RateLimiterWrapper rateLimiterWrapper = this.ref.get();
        return rateLimiterWrapper != null ? rateLimiterWrapper.rateLimiter.getRate() : 0.0;
    }

    @CanIgnoreReturnValue
    public double acquire() {
        RateLimiterWrapper rateLimiterWrapper = this.ref.get();
        return rateLimiterWrapper != null ? rateLimiterWrapper.rateLimiter.acquire() : 0.0;
    }

    @CanIgnoreReturnValue
    public double acquire(int permits) {
        RateLimiterWrapper rateLimiterWrapper = this.ref.get();
        return rateLimiterWrapper != null && permits > 0 ? rateLimiterWrapper.rateLimiter.acquire(permits) : 0.0;
    }

    private static class RateLimiterWrapper {
        private final RateLimiter rateLimiter;
        private final RateLimiter.SleepingStopwatch stopwatch;

        private RateLimiterWrapper(RateLimiter rateLimiter, RateLimiter.SleepingStopwatch stopwatch) {
            this.rateLimiter = rateLimiter;
            this.stopwatch = stopwatch;
        }

        static RateLimiterWrapper create(double permitsPerSecond) {
            RateLimiter.SleepingStopwatch stopwatch = RateLimiter.SleepingStopwatch.createFromSystemTimer();
            RateLimiter rateLimiter = RateLimiter.create((double)permitsPerSecond, (RateLimiter.SleepingStopwatch)stopwatch);
            return new RateLimiterWrapper(rateLimiter, stopwatch);
        }

        public long queryWaitTimeInMicros() {
            long earliestAvailableMicros = this.rateLimiter.queryEarliestAvailable(0L);
            long nowMicros = this.stopwatch.readMicros();
            return Math.max(earliestAvailableMicros - nowMicros, 0L);
        }
    }
}

