/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TokenRangeReplicasResponse {
    private final List<ReplicaInfo> writeReplicas;
    private final List<ReplicaInfo> readReplicas;
    private final Map<String, ReplicaMetadata> replicaMetadata;

    public TokenRangeReplicasResponse(@JsonProperty(value="writeReplicas") List<ReplicaInfo> writeReplicas, @JsonProperty(value="readReplicas") List<ReplicaInfo> readReplicas, @JsonProperty(value="replicaMetadata") Map<String, ReplicaMetadata> replicaMetadata) {
        this.writeReplicas = writeReplicas;
        this.readReplicas = readReplicas;
        this.replicaMetadata = replicaMetadata;
    }

    @JsonProperty(value="replicaMetadata")
    public Map<String, ReplicaMetadata> replicaMetadata() {
        return this.replicaMetadata;
    }

    @JsonProperty(value="writeReplicas")
    public List<ReplicaInfo> writeReplicas() {
        return this.writeReplicas;
    }

    @JsonProperty(value="readReplicas")
    public List<ReplicaInfo> readReplicas() {
        return this.readReplicas;
    }

    public static class ReplicaMetadata {
        private final String state;
        private final String status;
        private final String fqdn;
        private final String address;
        private final int port;
        private final String datacenter;

        public ReplicaMetadata(@JsonProperty(value="state") String state, @JsonProperty(value="status") String status, @JsonProperty(value="fqdn") String fqdn, @JsonProperty(value="address") String address, @JsonProperty(value="port") int port, @JsonProperty(value="datacenter") String datacenter) {
            this.state = state;
            this.status = status;
            this.fqdn = fqdn;
            this.address = address;
            this.port = port;
            this.datacenter = datacenter;
        }

        @JsonProperty(value="state")
        public String state() {
            return this.state;
        }

        @JsonProperty(value="status")
        public String status() {
            return this.status;
        }

        @JsonProperty(value="fqdn")
        public String fqdn() {
            return this.fqdn;
        }

        @JsonProperty(value="address")
        public String address() {
            return this.address;
        }

        @JsonProperty(value="port")
        public int port() {
            return this.port;
        }

        @JsonProperty(value="datacenter")
        public String datacenter() {
            return this.datacenter;
        }

        public String toString() {
            return "ReplicaMetadata{state='" + this.state + '\'' + ", status='" + this.status + '\'' + ", fqdn='" + this.fqdn + '\'' + ", address='" + this.address + '\'' + ", port='" + this.port + '\'' + ", datacenter='" + this.datacenter + '\'' + '}';
        }
    }

    public static class ReplicaInfo {
        private final String start;
        private final String end;
        private final Map<String, List<String>> replicasByDatacenter;

        public ReplicaInfo(@JsonProperty(value="start") String start, @JsonProperty(value="end") String end, @JsonProperty(value="replicas") Map<String, List<String>> replicasByDatacenter) {
            this.start = start;
            this.end = end;
            this.replicasByDatacenter = replicasByDatacenter;
        }

        @JsonProperty(value="start")
        public String start() {
            return this.start;
        }

        @JsonProperty(value="end")
        public String end() {
            return this.end;
        }

        @JsonProperty(value="replicasByDatacenter")
        public Map<String, List<String>> replicasByDatacenter() {
            return this.replicasByDatacenter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaInfo that = (ReplicaInfo)o;
            return this.start.equals(that.start) && this.end.equals(that.end) && this.replicasByDatacenter.equals(that.replicasByDatacenter);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end, this.replicasByDatacenter);
        }

        public String toString() {
            return "ReplicaInfo{start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", replicasByDatacenter=" + this.replicasByDatacenter + '}';
        }
    }
}

