/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.common.utils.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NodeCommandRequestPayload {
    private final State state;

    @JsonCreator
    public NodeCommandRequestPayload(@JsonProperty(value="state", required=true) String state) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(state), "state must be provided and non-empty");
        this.state = State.fromString(state);
    }

    @JsonProperty(value="state")
    public State state() {
        return this.state;
    }

    public String toString() {
        return "NodeCommandRequestPayload{state=" + (Object)((Object)this.state) + '}';
    }

    public static enum State {
        START,
        STOP;


        @JsonCreator
        public static State fromString(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Null state");
            }
            switch (s.trim().toLowerCase()) {
                case "start": {
                    return START;
                }
                case "stop": {
                    return STOP;
                }
            }
            throw new IllegalArgumentException("Unknown state: " + s);
        }

        @JsonProperty
        public String toValue() {
            return this.name().toLowerCase();
        }
    }
}

