/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.cassandra.sidecar.common.request.ResponseBytesDecoder;

public class JsonResponseBytesDecoder<T>
implements ResponseBytesDecoder<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final Class<T> type;

    public JsonResponseBytesDecoder(Class<T> type) {
        this.type = type;
    }

    @Override
    public T decode(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return (T)MAPPER.readValue(bytes, this.type);
    }
}

