/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.request.JsonRequest;
import org.apache.cassandra.sidecar.common.response.SSTableImportResponse;

public class ImportSSTableRequest
extends JsonRequest<SSTableImportResponse> {
    public ImportSSTableRequest(String keyspace, String tableName, String uploadId, ImportOptions importOptions) {
        super(ImportSSTableRequest.requestURI(keyspace, tableName, uploadId, importOptions));
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.PUT;
    }

    static String requestURI(String keyspace, String tableName, String uploadId, ImportOptions importOptions) {
        String requestUri = "/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/import".replaceAll(":uploadId", uploadId).replaceAll(":keyspace", keyspace).replaceAll(":table", tableName);
        List<String> options = ImportSSTableRequest.selectedOptions(importOptions);
        if (options.isEmpty()) {
            return requestUri;
        }
        return requestUri + options.stream().collect(Collectors.joining("&", "?", ""));
    }

    private static List<String> selectedOptions(ImportOptions importOptions) {
        ArrayList<String> options = new ArrayList<String>();
        if (importOptions.resetLevel != null) {
            options.add("resetLevel=" + importOptions.resetLevel);
        }
        if (importOptions.clearRepaired != null) {
            options.add("clearRepaired=" + importOptions.clearRepaired);
        }
        if (importOptions.verifySSTables != null) {
            options.add("verifySSTables=" + importOptions.verifySSTables);
        }
        if (importOptions.verifyTokens != null) {
            options.add("verifyTokens=" + importOptions.verifyTokens);
        }
        if (importOptions.invalidateCaches != null) {
            options.add("invalidateCaches=" + importOptions.invalidateCaches);
        }
        if (importOptions.extendedVerify != null) {
            options.add("extendedVerify=" + importOptions.extendedVerify);
        }
        if (importOptions.copyData != null) {
            options.add("copyData=" + importOptions.copyData);
        }
        return options;
    }

    public static class ImportOptions {
        private Boolean resetLevel;
        private Boolean clearRepaired;
        private Boolean verifySSTables;
        private Boolean verifyTokens;
        private Boolean invalidateCaches;
        private Boolean extendedVerify;
        private Boolean copyData;

        public ImportOptions resetLevel(boolean resetLevel) {
            this.resetLevel = resetLevel;
            return this;
        }

        public ImportOptions clearRepaired(boolean clearRepaired) {
            this.clearRepaired = clearRepaired;
            return this;
        }

        public ImportOptions verifySSTables(boolean verifySSTables) {
            this.verifySSTables = verifySSTables;
            return this;
        }

        public ImportOptions verifyTokens(boolean verifyTokens) {
            this.verifyTokens = verifyTokens;
            return this;
        }

        public ImportOptions invalidateCaches(boolean invalidateCaches) {
            this.invalidateCaches = invalidateCaches;
            return this;
        }

        public ImportOptions extendedVerify(boolean extendedVerify) {
            this.extendedVerify = extendedVerify;
            return this;
        }

        public ImportOptions copyData(boolean copyData) {
            this.copyData = copyData;
            return this;
        }
    }
}

