/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cassandra.spark.data;

import org.jetbrains.annotations.NotNull;

public interface TypeConverter
{
    TypeConverter IDENTITY = (cqlType, value, isFrozen) -> value;

    /**
     * Converts deserialized Cassandra Java value to desired equivalent type.
     * E.g. SparkSQL uses `org.apache.spark.unsafe.types.UTF8String` to wrap strings.
     * E.g. SparkSQL starts counting dates from 1970-01-01 = 0, but Cassandra starts at 1970-01-01 = Integer.MIN_VALUE.
     *
     * @param cqlType  cql type
     * @param value    cassandra value
     * @param isFrozen true if type or parent type is a frozen type
     * @return equivalent value in new data format.
     */
    Object convert(CqlField.CqlType cqlType, @NotNull Object value, boolean isFrozen);
}
