/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public class Collectors3 {
    private static final Collector.Characteristics[] LIST_CHARACTERISTICS = new Collector.Characteristics[0];
    private static final Collector.Characteristics[] SET_CHARACTERISTICS = new Collector.Characteristics[]{Collector.Characteristics.UNORDERED};
    private static final Collector.Characteristics[] MAP_CHARACTERISTICS = new Collector.Characteristics[]{Collector.Characteristics.UNORDERED};

    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableList.Builder::build, LIST_CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return Collector.of(ImmutableSet.Builder::new, ImmutableSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSet.Builder::build, SET_CHARACTERISTICS);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableMap<K, V>> toImmutableMap() {
        return Collector.of(ImmutableMap.Builder::new, ImmutableMap.Builder::put, (l, r) -> l.putAll((Map)r.build()), ImmutableMap.Builder::build, MAP_CHARACTERISTICS);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(ImmutableMap.Builder::new, (b, t) -> b.put(keyMapper.apply(t), valueMapper.apply(t)), (l, r) -> l.putAll((Map)r.build()), ImmutableMap.Builder::build, MAP_CHARACTERISTICS);
    }
}

