/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DecimalSerializer
extends TypeSerializer<BigDecimal> {
    public static final DecimalSerializer instance = new DecimalSerializer();

    @Override
    public <V> BigDecimal deserialize(V value, ValueAccessor<V> accessor) {
        if (value == null || accessor.isEmpty(value)) {
            return null;
        }
        int scale = accessor.getInt(value, 0);
        BigInteger bi = new BigInteger(accessor.toArray(value, 4, accessor.size(value) - 4));
        return new BigDecimal(bi, scale);
    }

    @Override
    public ByteBuffer serialize(BigDecimal value) {
        if (value == null) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        BigInteger bi = value.unscaledValue();
        int scale = value.scale();
        byte[] bibytes = bi.toByteArray();
        ByteBuffer bytes = ByteBuffer.allocate(4 + bibytes.length);
        bytes.putInt(scale);
        bytes.put(bibytes);
        bytes.rewind();
        return bytes;
    }

    @Override
    public <T> void validate(T value, ValueAccessor<T> accessor) throws MarshalException {
        if (!accessor.isEmpty(value) && accessor.size(value) < 4) {
            throw new MarshalException(String.format("Expected 0 or at least 4 bytes (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(BigDecimal value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }
}

