/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.net.InetSocketAddress;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.client.ConnectStringParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConnectStringParserTest
extends ZKTestCase {
    private static final int DEFAULT_PORT = 2181;

    @Test
    public void testSingleServerChrootPath() {
        String chrootPath = "/hallo/welt";
        String servers = "10.10.10.1";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
        servers = "[2001:db8:1::242:ac11:2]";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
    }

    @Test
    public void testMultipleServersChrootPath() {
        String chrootPath = "/hallo/welt";
        String servers = "10.10.10.1,10.10.10.2";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
        servers = "[2001:db8:1::242:ac11:2]:2181,[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
    }

    @Test
    public void testParseServersWithoutPort() {
        String servers = "10.10.10.1,10.10.10.2";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assertions.assertEquals((Object)"10.10.10.1", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assertions.assertEquals((int)2181, (int)((InetSocketAddress)parser.getServerAddresses().get(0)).getPort());
        Assertions.assertEquals((Object)"10.10.10.2", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
        Assertions.assertEquals((int)2181, (int)((InetSocketAddress)parser.getServerAddresses().get(1)).getPort());
        servers = "[2001:db8:1::242:ac11:2],[2001:db8:85a3:8d3:1319:8a2e:370:7348]";
        parser = new ConnectStringParser(servers);
        Assertions.assertEquals((Object)"2001:db8:1::242:ac11:2", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assertions.assertEquals((int)2181, (int)((InetSocketAddress)parser.getServerAddresses().get(0)).getPort());
        Assertions.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
        Assertions.assertEquals((int)2181, (int)((InetSocketAddress)parser.getServerAddresses().get(1)).getPort());
    }

    @Test
    public void testParseServersWithPort() {
        String servers = "10.10.10.1:112,10.10.10.2:110";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assertions.assertEquals((Object)"10.10.10.1", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assertions.assertEquals((Object)"10.10.10.2", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
        Assertions.assertEquals((int)112, (int)((InetSocketAddress)parser.getServerAddresses().get(0)).getPort());
        Assertions.assertEquals((int)110, (int)((InetSocketAddress)parser.getServerAddresses().get(1)).getPort());
        servers = "[2001:db8:1::242:ac11:2]:1234,[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678";
        parser = new ConnectStringParser(servers);
        Assertions.assertEquals((Object)"2001:db8:1::242:ac11:2", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assertions.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
        Assertions.assertEquals((int)1234, (int)((InetSocketAddress)parser.getServerAddresses().get(0)).getPort());
        Assertions.assertEquals((int)5678, (int)((InetSocketAddress)parser.getServerAddresses().get(1)).getPort());
    }

    private void assertChrootPath(String expected, ConnectStringParser parser) {
        Assertions.assertEquals((Object)expected, (Object)parser.getChrootPath());
    }

    @Test
    public void testParseIPV6ConnectionString() {
        String servers = "[127::1],127.0.10.2";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assertions.assertEquals((Object)"127::1", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assertions.assertEquals((Object)"127.0.10.2", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
        Assertions.assertEquals((int)2181, (int)((InetSocketAddress)parser.getServerAddresses().get(0)).getPort());
        Assertions.assertEquals((int)2181, (int)((InetSocketAddress)parser.getServerAddresses().get(1)).getPort());
        servers = "[127::1]:2181,[127::2]:2182,[127::3]:2183";
        parser = new ConnectStringParser(servers);
        Assertions.assertEquals((Object)"127::1", (Object)((InetSocketAddress)parser.getServerAddresses().get(0)).getHostString());
        Assertions.assertEquals((Object)"127::2", (Object)((InetSocketAddress)parser.getServerAddresses().get(1)).getHostString());
        Assertions.assertEquals((Object)"127::3", (Object)((InetSocketAddress)parser.getServerAddresses().get(2)).getHostString());
        Assertions.assertEquals((int)2181, (int)((InetSocketAddress)parser.getServerAddresses().get(0)).getPort());
        Assertions.assertEquals((int)2182, (int)((InetSocketAddress)parser.getServerAddresses().get(1)).getPort());
        Assertions.assertEquals((int)2183, (int)((InetSocketAddress)parser.getServerAddresses().get(2)).getPort());
    }
}

