/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CreateTest
extends ClientBase {
    private ZooKeeper zk;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testCreate() throws IOException, KeeperException, InterruptedException {
        this.createNoStatVerifyResult("/foo");
        this.createNoStatVerifyResult("/foo/child");
    }

    @Test
    public void testCreateWithStat() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        Stat stat = this.createWithStatVerifyResult("/foo");
        Stat childStat = this.createWithStatVerifyResult("/foo/child");
        Assertions.assertFalse((boolean)stat.equals((Object)childStat));
    }

    @Test
    public void testCreateWithNullStat() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        Assertions.assertNull((Object)this.zk.exists(name, false));
        Stat stat = null;
        String path = this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        Assertions.assertNull(stat);
        Assertions.assertNotNull((Object)this.zk.exists(name, false));
    }

    private void createNoStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assertions.assertNull((Object)this.zk.exists(newName, false), (String)"Node existed before created");
        String path = this.zk.create(newName, newName.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)path, (Object)newName);
        Assertions.assertNotNull((Object)this.zk.exists(newName, false), (String)"Node was not created as expected");
    }

    private Stat createWithStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assertions.assertNull((Object)this.zk.exists(newName, false), (String)"Node existed before created");
        Stat stat = new Stat();
        String path = this.zk.create(newName, newName.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        Assertions.assertEquals((Object)path, (Object)newName);
        this.validateCreateStat(stat, newName);
        Stat referenceStat = this.zk.exists(newName, false);
        Assertions.assertNotNull((Object)referenceStat, (String)"Node was not created as expected");
        Assertions.assertEquals((Object)referenceStat, (Object)stat);
        return stat;
    }

    private void validateCreateStat(Stat stat, String name) {
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)0, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)name.length(), (int)stat.getDataLength());
        Assertions.assertEquals((int)0, (int)stat.getNumChildren());
    }
}

