/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Partitioner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class BinaryPartitioner<V>
extends Partitioner<BinaryComparable, V>
implements Configurable {
    public static final String LEFT_OFFSET_PROPERTY_NAME = "mapreduce.partition.binarypartitioner.left.offset";
    public static final String RIGHT_OFFSET_PROPERTY_NAME = "mapreduce.partition.binarypartitioner.right.offset";
    private Configuration conf;
    private int leftOffset;
    private int rightOffset;

    public static void setOffsets(Configuration conf, int left, int right) {
        conf.setInt(LEFT_OFFSET_PROPERTY_NAME, left);
        conf.setInt(RIGHT_OFFSET_PROPERTY_NAME, right);
    }

    public static void setLeftOffset(Configuration conf, int offset) {
        conf.setInt(LEFT_OFFSET_PROPERTY_NAME, offset);
    }

    public static void setRightOffset(Configuration conf, int offset) {
        conf.setInt(RIGHT_OFFSET_PROPERTY_NAME, offset);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.leftOffset = conf.getInt(LEFT_OFFSET_PROPERTY_NAME, 0);
        this.rightOffset = conf.getInt(RIGHT_OFFSET_PROPERTY_NAME, -1);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int getPartition(BinaryComparable key, V value, int numPartitions) {
        int length = key.getLength();
        int leftIndex = (this.leftOffset + length) % length;
        int rightIndex = (this.rightOffset + length) % length;
        int hash = WritableComparator.hashBytes((byte[])key.getBytes(), (int)leftIndex, (int)(rightIndex - leftIndex + 1));
        return (hash & Integer.MAX_VALUE) % numPartitions;
    }
}

