/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.processor;

import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.UseDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.ColumnFilterPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class ExternalDatasetFilterPushdownProcessor
extends ColumnFilterPushdownProcessor {
    private ExternalDataPrefix prefix;

    public ExternalDatasetFilterPushdownProcessor(PushdownContext pushdownContext, IOptimizationContext context) {
        super(pushdownContext, context);
    }

    @Override
    protected boolean skip(ScanDefineDescriptor scanDefineDescriptor) throws AlgebricksException {
        Dataset dataset = scanDefineDescriptor.getDataset();
        LogicalOperatorTag scanOpTag = scanDefineDescriptor.getOperator().getOperatorTag();
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
            return true;
        }
        ExternalDatasetDetails edd = (ExternalDatasetDetails)dataset.getDatasetDetails();
        this.prefix = new ExternalDataPrefix(edd.getProperties());
        return !this.prefix.hasComputedFields() || scanOpTag != LogicalOperatorTag.DATASOURCESCAN || !DatasetUtil.isFilterPushdownSupported((Dataset)dataset);
    }

    @Override
    protected void preparePushdown(UseDescriptor useDescriptor, ScanDefineDescriptor scanDescriptor) throws AlgebricksException {
        super.preparePushdown(useDescriptor, scanDescriptor);
    }

    @Override
    protected boolean isNotPushable(AbstractFunctionCallExpression expression) {
        FunctionIdentifier fid = expression.getFunctionIdentifier();
        return PushdownUtil.ARRAY_FUNCTIONS.contains(fid) || super.isNotPushable(expression);
    }

    @Override
    protected boolean handlePath(AbstractFunctionCallExpression expression) throws AlgebricksException {
        IExpectedSchemaNode node = (IExpectedSchemaNode)expression.accept((ILogicalExpressionVisitor)this.exprToNodeVisitor, null);
        if (node == null || node.getType() != ExpectedSchemaNodeType.ANY) {
            return false;
        }
        ARecordType expressionPath = this.pathBuilderVisitor.buildPath((AnyExpectedSchemaNode)node);
        if (this.prefix.getPaths().contains(expressionPath)) {
            this.paths.put(expression, expressionPath);
            return true;
        }
        return false;
    }
}

