/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval.utils;

import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtil;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.OverlappingIntervalJoinUtil;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class OverlappingIntervalJoinUtilFactory
implements IIntervalJoinUtilFactory {
    private static final long serialVersionUID = 1L;
    private final RangeMap rangeMap;

    public OverlappingIntervalJoinUtilFactory(RangeMap rangeMap) {
        this.rangeMap = rangeMap;
    }

    @Override
    public IIntervalJoinUtil createIntervalMergeJoinUtil(int buildKey, int probeKey, IHyracksTaskContext ctx, int nPartitions) throws HyracksDataException {
        int fieldIndex = 0;
        int partition = ctx.getTaskAttemptId().getTaskId().getPartition();
        int nRanges = this.rangeMap.getSplitCount() + 1;
        double rangesPerPart = 1.0;
        if (nRanges > nPartitions) {
            rangesPerPart = (double)nRanges / (double)nPartitions;
        }
        int slot = (int)Math.ceil((double)partition * rangesPerPart) % nRanges - 1;
        long partitionStart = Long.MIN_VALUE;
        if (slot >= 0) {
            switch (ATypeTag.VALUE_TYPE_MAPPING[this.rangeMap.getTag(fieldIndex, slot)]) {
                case DATETIME: {
                    partitionStart = ADateTimeSerializerDeserializer.getChronon((byte[])this.rangeMap.getByteArray(), (int)(this.rangeMap.getStartOffset(fieldIndex, slot) + 1));
                    break;
                }
                case DATE: {
                    partitionStart = ADateSerializerDeserializer.getChronon((byte[])this.rangeMap.getByteArray(), (int)(this.rangeMap.getStartOffset(fieldIndex, slot) + 1));
                    break;
                }
                case TIME: {
                    partitionStart = ATimeSerializerDeserializer.getChronon((byte[])this.rangeMap.getByteArray(), (int)(this.rangeMap.getStartOffset(fieldIndex, slot) + 1));
                    break;
                }
                default: {
                    throw new HyracksDataException("RangeMap type is not supported");
                }
            }
        }
        return new OverlappingIntervalJoinUtil(buildKey, probeKey, partitionStart);
    }
}

