/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONArray;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.Converter;

public class CollectionAccessor
implements ObjectAccessor {
    @Override
    public Class<?> getType() {
        return Collection.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pCollection, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        Collection collection = (Collection)pCollection;
        int length = pConverter.getCollectionLength(collection.size());
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            return this.extractCollectionItem(pConverter, collection, pPathParts, pJsonify, pathPart, length);
        }
        return pJsonify ? this.collectionToJSON(pConverter, collection, pPathParts, length) : collection;
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pObject, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("A collection (beside Lists and Maps) cannot be modified");
    }

    private Object collectionToJSON(ObjectToJsonConverter pConverter, Collection<?> pCollection, Deque<String> pPath, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray(pLength);
        Iterator<?> it = pCollection.iterator();
        for (int idx = 0; it.hasNext() && idx < pLength; ++idx) {
            Object item = it.next();
            LinkedList<String> path = new LinkedList<String>(pPath);
            try {
                ret.add(pConverter.extractObject(item, path, true));
                continue;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
                // empty catch block
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractCollectionItem(ObjectToJsonConverter pConverter, Collection<?> pCollection, Deque<String> pPath, boolean pJsonify, String pPathPart, int pLength) throws AttributeNotFoundException {
        try {
            int idx = Integer.parseInt(pPathPart);
            return pConverter.extractObject(this.getElement(pCollection, idx, pLength), pPath, pJsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is not numeric for accessing a collection"));
        }
        catch (IndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for a collection of size " + pLength));
        }
    }

    private Object getElement(Collection<?> pCollection, int pIdx, int pLength) {
        Iterator<?> it = pCollection.iterator();
        for (int i = 0; it.hasNext() && i < pLength; ++i) {
            Object val = it.next();
            if (i != pIdx) continue;
            return val;
        }
        throw new IndexOutOfBoundsException("Collection index " + pIdx + " larger than size " + pLength);
    }
}

