/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Expression;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.PropertyExpressionDefinition;
import org.apache.camel.model.SagaActionUriDefinition;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.TimeUtils;

@Metadata(label="eip,routing")
@XmlRootElement(name="saga")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SagaDefinition
extends OutputDefinition<SagaDefinition> {
    @XmlTransient
    private CamelSagaService sagaServiceBean;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.saga.CamelSagaService")
    private String sagaService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.model.SagaPropagation", defaultValue="REQUIRED", enums="REQUIRED,REQUIRES_NEW,MANDATORY,SUPPORTS,NOT_SUPPORTED,NEVER")
    private String propagation;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.model.SagaCompletionMode", defaultValue="AUTO", enums="AUTO,MANUAL")
    private String completionMode;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration")
    private String timeout;
    @XmlElement
    private SagaActionUriDefinition compensation;
    @XmlElement
    private SagaActionUriDefinition completion;
    @XmlElement(name="option")
    @Metadata(label="advanced")
    private List<PropertyExpressionDefinition> options;

    public SagaDefinition() {
    }

    protected SagaDefinition(SagaDefinition source) {
        super(source);
        this.sagaServiceBean = source.sagaServiceBean;
        this.sagaService = source.sagaService;
        this.propagation = source.propagation;
        this.completionMode = source.completionMode;
        this.timeout = source.timeout;
        this.compensation = source.compensation != null ? source.compensation.copyDefinition() : null;
        this.completion = source.completion != null ? source.completion.copyDefinition() : null;
        this.options = ProcessorDefinitionHelper.deepCopyDefinitions(source.options);
    }

    @Override
    public SagaDefinition copyDefinition() {
        return new SagaDefinition(this);
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public boolean isWrappingEntireOutput() {
        return true;
    }

    @Override
    public String getLabel() {
        String desc = this.description();
        if (ObjectHelper.isEmpty((String)desc)) {
            return "saga";
        }
        return "saga[" + desc + "]";
    }

    @Override
    public String toString() {
        String desc = this.description();
        if (ObjectHelper.isEmpty((String)desc)) {
            return "Saga -> [" + String.valueOf(this.outputs) + "]";
        }
        return "Saga[" + desc + "] -> [" + String.valueOf(this.outputs) + "]";
    }

    public CamelSagaService getSagaServiceBean() {
        return this.sagaServiceBean;
    }

    public String getSagaService() {
        return this.sagaService;
    }

    public void setSagaService(String sagaService) {
        this.sagaService = sagaService;
    }

    public SagaActionUriDefinition getCompensation() {
        return this.compensation;
    }

    public void setCompensation(SagaActionUriDefinition compensation) {
        this.compensation = compensation;
    }

    public SagaActionUriDefinition getCompletion() {
        return this.completion;
    }

    public void setCompletion(SagaActionUriDefinition completion) {
        this.completion = completion;
    }

    public String getPropagation() {
        return this.propagation;
    }

    public void setPropagation(String propagation) {
        this.propagation = propagation;
    }

    public String getCompletionMode() {
        return this.completionMode;
    }

    public void setCompletionMode(String completionMode) {
        this.completionMode = completionMode;
    }

    public List<PropertyExpressionDefinition> getOptions() {
        return this.options;
    }

    public void setOptions(List<PropertyExpressionDefinition> options) {
        this.options = options;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    private void addOption(String option, Expression expression) {
        if (this.options == null) {
            this.options = new ArrayList<PropertyExpressionDefinition>();
        }
        this.options.add(new PropertyExpressionDefinition(option, expression));
    }

    public SagaDefinition compensation(String compensation) {
        if (this.compensation != null) {
            throw new IllegalStateException("Compensation has already been set");
        }
        this.compensation = new SagaActionUriDefinition(compensation);
        return this;
    }

    public SagaDefinition completion(String completion) {
        if (this.completion != null) {
            throw new IllegalStateException("Completion has already been set");
        }
        this.completion = new SagaActionUriDefinition(completion);
        return this;
    }

    public SagaDefinition propagation(SagaPropagation propagation) {
        this.setPropagation(propagation.name());
        return this;
    }

    public SagaDefinition sagaService(CamelSagaService sagaService) {
        this.sagaServiceBean = sagaService;
        return this;
    }

    public SagaDefinition sagaService(String sagaService) {
        this.setSagaService(sagaService);
        return this;
    }

    public SagaDefinition completionMode(SagaCompletionMode completionMode) {
        return this.completionMode(completionMode.name());
    }

    public SagaDefinition completionMode(String completionMode) {
        this.setCompletionMode(completionMode);
        return this;
    }

    public SagaDefinition option(String option, Expression expression) {
        this.addOption(option, expression);
        return this;
    }

    public SagaDefinition timeout(Duration duration) {
        return this.timeout(TimeUtils.printDuration((Duration)duration, (boolean)true));
    }

    public SagaDefinition timeout(long timeout, TimeUnit unit) {
        return this.timeout(Duration.ofMillis(unit.toMillis(timeout)));
    }

    public SagaDefinition timeout(String duration) {
        this.setTimeout(duration);
        return this;
    }

    protected String description() {
        StringBuilder desc = new StringBuilder(256);
        this.addField(desc, "compensation", this.compensation);
        this.addField(desc, "completion", this.completion);
        this.addField(desc, "propagation", this.propagation);
        return desc.toString();
    }

    private void addField(StringBuilder builder, String key, Object value) {
        if (value == null) {
            return;
        }
        if (!builder.isEmpty()) {
            builder.append(',');
        }
        builder.append(key).append(':').append(value);
    }
}

