/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml.util.jsse;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import javax.net.ssl.TrustManager;
import org.apache.camel.CamelContext;
import org.apache.camel.core.xml.util.jsse.AbstractJsseUtilFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractKeyStoreParametersFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.jsse.TrustManagersParameters;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractTrustManagersParametersFactoryBean
extends AbstractJsseUtilFactoryBean<TrustManagersParameters> {
    @XmlAttribute
    @Metadata(label="advanced", description="The provider identifier for the TrustManagerFactory used to create TrustManagers represented by this object's configuration.")
    protected String provider;
    @XmlAttribute
    @Metadata(label="advanced", description="The optional algorithm name for the TrustManagerFactory used to create the TrustManagers represented by this objects configuration. See https://docs.oracle.com/en/java/javase/17/docs/specs/security/standard-names.html")
    protected String algorithm;
    @XmlAttribute
    @Metadata(label="advanced", description="To use a existing configured trust manager instead of using TrustManagerFactory to get the TrustManager.")
    protected String trustManager;
    @XmlTransient
    private TrustManagersParameters instance;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(String trustManager) {
        this.trustManager = trustManager;
    }

    @Override
    public TrustManagersParameters getObject() throws Exception {
        if (this.isSingleton()) {
            if (this.instance == null) {
                this.instance = this.createInstance();
            }
            return this.instance;
        }
        return this.createInstance();
    }

    @Override
    public Class<TrustManagersParameters> getObjectType() {
        return TrustManagersParameters.class;
    }

    protected TrustManagersParameters createInstance() throws Exception {
        TrustManagersParameters newInstance = new TrustManagersParameters();
        newInstance.setAlgorithm(this.algorithm);
        if (this.getKeyStore() != null) {
            this.getKeyStore().setCamelContext(this.getCamelContext());
            newInstance.setKeyStore(this.getKeyStore().getObject());
        }
        newInstance.setProvider(this.provider);
        newInstance.setCamelContext(this.getCamelContext());
        if (this.trustManager != null) {
            TrustManager tm = (TrustManager)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.trustManager, TrustManager.class);
            newInstance.setTrustManager(tm);
        }
        return newInstance;
    }

    protected abstract AbstractKeyStoreParametersFactoryBean getKeyStore();
}

