/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;

public class RandomLoadBalancer
extends QueueLoadBalancer {
    private transient int index;

    @Override
    protected AsyncProcessor chooseProcessor(AsyncProcessor[] processors, Exchange exchange) {
        int size = processors.length;
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return processors[0];
        }
        this.index = ThreadLocalRandom.current().nextInt(size);
        return processors[this.index];
    }

    public int getLastChosenProcessorIndex() {
        return this.index;
    }
}

