/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.recovery;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.server.manager.recovery.HadoopLogCloser;
import org.apache.accumulo.server.manager.recovery.LogCloser;
import org.apache.accumulo.server.manager.recovery.RecoveryPath;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryManager {
    private static final Logger log = LoggerFactory.getLogger(RecoveryManager.class);
    private final Map<String, Long> recoveryDelay = new HashMap<String, Long>();
    private final Set<String> closeTasksQueued = new HashSet<String>();
    private final Set<String> sortsQueued = new HashSet<String>();
    private final Cache<Path, Boolean> existenceCache;
    private final ScheduledExecutorService executor;
    private final Manager manager;
    private final ZooCache zooCache;

    public RecoveryManager(Manager manager, long timeToCacheExistsInMillis) {
        this.manager = manager;
        this.existenceCache = CacheBuilder.newBuilder().expireAfterWrite(timeToCacheExistsInMillis, TimeUnit.MILLISECONDS).maximumWeight(10000000L).weigher((path, exist) -> path.toString().length()).build();
        this.executor = ThreadPools.getServerThreadPools().createScheduledExecutorService(4, "Walog sort starter");
        this.zooCache = new ZooCache(manager.getContext().getZooReader(), null);
        try {
            List workIDs = new DistributedWorkQueue(manager.getZooKeeperRoot() + "/recovery", manager.getConfiguration(), (AbstractServer)manager).getWorkQueued();
            this.sortsQueued.addAll(workIDs);
        }
        catch (Exception e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateSort(String sortId, String source, String destination) throws KeeperException, InterruptedException {
        String work = source + "|" + destination;
        new DistributedWorkQueue(this.manager.getZooKeeperRoot() + "/recovery", this.manager.getConfiguration(), (AbstractServer)this.manager).addWork(sortId, work.getBytes(StandardCharsets.UTF_8));
        RecoveryManager recoveryManager = this;
        synchronized (recoveryManager) {
            this.sortsQueued.add(sortId);
        }
        String path = this.manager.getZooKeeperRoot() + "/recovery/" + sortId;
        log.info("Created zookeeper entry {} with data {}", (Object)path, (Object)work);
    }

    private boolean exists(Path path) throws IOException {
        try {
            return (Boolean)this.existenceCache.get((Object)path, () -> this.manager.getVolumeManager().exists(path));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverLogs(KeyExtent extent, Collection<Collection<String>> walogs) throws IOException {
        boolean recoveryNeeded = false;
        for (Collection<String> logs : walogs) {
            for (String walog : logs) {
                boolean sortQueued;
                Path switchedWalog = VolumeUtil.switchVolume((String)walog, (VolumeManager.FileType)VolumeManager.FileType.WAL, (List)this.manager.getContext().getVolumeReplacements());
                if (switchedWalog != null) {
                    log.info("Volume replaced {} -> {}", (Object)walog, (Object)switchedWalog);
                    walog = switchedWalog.toString();
                }
                String[] parts = walog.split("/");
                String sortId = parts[parts.length - 1];
                String filename = new Path(walog).toString();
                String dest = RecoveryPath.getRecoveryPath((Path)new Path(filename)).toString();
                RecoveryManager recoveryManager = this;
                synchronized (recoveryManager) {
                    sortQueued = this.sortsQueued.contains(sortId);
                }
                if (sortQueued && this.zooCache.get(this.manager.getZooKeeperRoot() + "/recovery/" + sortId) == null) {
                    recoveryManager = this;
                    synchronized (recoveryManager) {
                        this.sortsQueued.remove(sortId);
                    }
                }
                if (this.exists(SortedLogState.getFinishedMarkerPath((String)dest))) {
                    recoveryManager = this;
                    synchronized (recoveryManager) {
                        this.closeTasksQueued.remove(sortId);
                        this.recoveryDelay.remove(sortId);
                        this.sortsQueued.remove(sortId);
                        continue;
                    }
                }
                recoveryNeeded = true;
                recoveryManager = this;
                synchronized (recoveryManager) {
                    if (!this.closeTasksQueued.contains(sortId) && !this.sortsQueued.contains(sortId)) {
                        AccumuloConfiguration aconf = this.manager.getConfiguration();
                        LogCloser closer = (LogCloser)Property.createInstanceFromPropertyName((AccumuloConfiguration)aconf, (Property)aconf.resolve(Property.MANAGER_WAL_CLOSER_IMPLEMENTATION, new Property[]{Property.MANAGER_WALOG_CLOSER_IMPLEMETATION}), LogCloser.class, (Object)new HadoopLogCloser());
                        Long delay = this.recoveryDelay.get(sortId);
                        delay = delay == null ? Long.valueOf(aconf.getTimeInMillis(Property.MANAGER_RECOVERY_DELAY)) : Long.valueOf(Math.min(2L * delay, 300000L));
                        log.info("Starting recovery of {} (in : {}s), tablet {} holds a reference", new Object[]{filename, delay / 1000L, extent});
                        ScheduledFuture<?> future = this.executor.schedule(new LogSortTask(closer, filename, dest, sortId), (long)delay, TimeUnit.MILLISECONDS);
                        ThreadPools.watchNonCriticalScheduledTask(future);
                        this.closeTasksQueued.add(sortId);
                        this.recoveryDelay.put(sortId, delay);
                    }
                }
            }
        }
        return recoveryNeeded;
    }

    private class LogSortTask
    implements Runnable {
        private final String source;
        private final String destination;
        private final String sortId;
        private final LogCloser closer;

        public LogSortTask(LogCloser closer, String source, String destination, String sortId) {
            this.closer = closer;
            this.source = source;
            this.destination = destination;
            this.sortId = sortId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean rescheduled = false;
            try {
                long time = this.closer.close(RecoveryManager.this.manager.getConfiguration(), RecoveryManager.this.manager.getContext().getHadoopConf(), RecoveryManager.this.manager.getVolumeManager(), new Path(this.source));
                if (time > 0L) {
                    ScheduledFuture<?> future = RecoveryManager.this.executor.schedule(this, time, TimeUnit.MILLISECONDS);
                    ThreadPools.watchNonCriticalScheduledTask(future);
                    rescheduled = true;
                } else {
                    RecoveryManager.this.initiateSort(this.sortId, this.source, this.destination);
                }
            }
            catch (FileNotFoundException e) {
                log.debug("Unable to initiate log sort for " + this.source + ": " + String.valueOf(e));
            }
            catch (Exception e) {
                log.warn("Failed to initiate log sort " + this.source, (Throwable)e);
            }
            finally {
                if (!rescheduled) {
                    RecoveryManager e = RecoveryManager.this;
                    synchronized (e) {
                        RecoveryManager.this.closeTasksQueued.remove(this.sortId);
                    }
                }
            }
        }
    }
}

