/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.accumulo.start.classloader.AccumuloClassLoader;
import org.apache.accumulo.start.classloader.vfs.AccumuloReloadingVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.accumulo.start.classloader.vfs.ReloadingClassLoader;
import org.apache.accumulo.start.classloader.vfs.UniqueFileReplicator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.gzip.GzipFileProvider;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileObject;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;
import org.apache.commons.vfs2.provider.https.HttpsFileProvider;
import org.apache.commons.vfs2.provider.jar.JarFileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AccumuloVFSClassLoader {
    private static List<WeakReference<DefaultFileSystemManager>> vfsInstances = Collections.synchronizedList(new ArrayList());
    public static final String DYNAMIC_CLASSPATH_PROPERTY_NAME = "general.dynamic.classpaths";
    public static final String DEFAULT_DYNAMIC_CLASSPATH_VALUE = "";
    public static final String VFS_CLASSLOADER_SYSTEM_CLASSPATH_PROPERTY = "general.vfs.classpaths";
    public static final String VFS_CONTEXT_CLASSPATH_PROPERTY = "general.vfs.context.classpath.";
    public static final String VFS_CACHE_DIR = "general.vfs.cache.dir";
    private static ClassLoader parent = null;
    private static volatile ReloadingClassLoader loader = null;
    private static final Object lock = new Object();
    private static ContextManager contextManager;
    private static final Logger log;

    static FileObject[] resolve(FileSystemManager vfs, String uris) throws FileSystemException {
        return AccumuloVFSClassLoader.resolve(vfs, uris, new ArrayList<FileObject>());
    }

    static FileObject[] resolve(FileSystemManager vfs, String uris, ArrayList<FileObject> pathsToMonitor) throws FileSystemException {
        if (uris == null) {
            return new FileObject[0];
        }
        ArrayList<FileObject> classpath = new ArrayList<FileObject>();
        pathsToMonitor.clear();
        block4: for (String path : uris.split(",")) {
            if ((path = path.trim()).equals(DEFAULT_DYNAMIC_CLASSPATH_VALUE)) continue;
            path = AccumuloClassLoader.replaceEnvVars(path, System.getenv());
            log.debug("Resolving path element: {}", (Object)path);
            FileObject fo = vfs.resolveFile(path);
            switch (fo.getType()) {
                case FILE: 
                case FOLDER: {
                    classpath.add(fo);
                    pathsToMonitor.add(fo);
                    continue block4;
                }
                case IMAGINARY: {
                    Pattern pattern = Pattern.compile(fo.getName().getBaseName());
                    if (fo.getParent() != null) {
                        pathsToMonitor.add(fo.getParent());
                        if (fo.getParent().getType() == FileType.FOLDER) {
                            FileObject[] children;
                            for (FileObject child : children = fo.getParent().getChildren()) {
                                if (child.getType() != FileType.FILE || !pattern.matcher(child.getName().getBaseName()).matches()) continue;
                                classpath.add(child);
                            }
                            continue block4;
                        }
                        log.debug("classpath entry " + String.valueOf(fo.getParent()) + " is " + String.valueOf(fo.getParent().getType()));
                        continue block4;
                    }
                    log.warn("ignoring classpath entry {}", (Object)fo);
                    continue block4;
                }
                default: {
                    log.warn("ignoring classpath entry {}", (Object)fo);
                }
            }
        }
        return classpath.toArray(new FileObject[classpath.size()]);
    }

    private static ReloadingClassLoader createDynamicClassloader(ClassLoader parent) throws IOException {
        String dynamicCPath = AccumuloClassLoader.getAccumuloProperty(DYNAMIC_CLASSPATH_PROPERTY_NAME, DEFAULT_DYNAMIC_CLASSPATH_VALUE);
        ReloadingClassLoader wrapper = () -> parent;
        if (dynamicCPath == null || dynamicCPath.equals(DEFAULT_DYNAMIC_CLASSPATH_VALUE)) {
            return wrapper;
        }
        return new AccumuloReloadingVFSClassLoader(dynamicCPath, AccumuloVFSClassLoader.generateVfs(), wrapper, 1000L, true);
    }

    public static ClassLoader getClassLoader() throws IOException {
        return AccumuloVFSClassLoader.getClassLoader_Internal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader getClassLoader_Internal() throws IOException {
        ReloadingClassLoader localLoader = loader;
        while (localLoader == null) {
            Object object = lock;
            synchronized (object) {
                if (loader == null) {
                    FileObject[] vfsCP;
                    FileSystemManager vfs = AccumuloVFSClassLoader.generateVfs();
                    if (parent == null) {
                        parent = AccumuloClassLoader.getClassLoader();
                    }
                    if ((vfsCP = AccumuloVFSClassLoader.resolve(vfs, AccumuloClassLoader.getAccumuloProperty(VFS_CLASSLOADER_SYSTEM_CLASSPATH_PROPERTY, DEFAULT_DYNAMIC_CLASSPATH_VALUE))).length == 0) {
                        loader = localLoader = AccumuloVFSClassLoader.createDynamicClassloader(parent);
                        return localLoader.getClassLoader();
                    }
                    loader = localLoader = AccumuloVFSClassLoader.createDynamicClassloader((ClassLoader)new VFSClassLoader(vfsCP, vfs, parent));
                    for (FileObject fo : vfsCP) {
                        if (!(fo instanceof HdfsFileObject)) continue;
                        String uri = fo.getName().getRootURI();
                        Configuration c = new Configuration(true);
                        c.set("fs.defaultFS", uri);
                        FileSystem fs = FileSystem.get((Configuration)c);
                        fs.getConf().setClassLoader(loader.getClassLoader());
                    }
                }
            }
        }
        return localLoader.getClassLoader();
    }

    public static FileSystemManager generateVfs() throws FileSystemException {
        DefaultFileSystemManager vfs = new DefaultFileSystemManager();
        vfs.addProvider("res", (FileProvider)new ResourceFileProvider());
        vfs.addProvider("zip", (FileProvider)new ZipFileProvider());
        vfs.addProvider("gz", (FileProvider)new GzipFileProvider());
        vfs.addProvider("ram", (FileProvider)new RamFileProvider());
        vfs.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        vfs.addProvider("jar", (FileProvider)new JarFileProvider());
        vfs.addProvider("http", (FileProvider)new HttpFileProvider());
        vfs.addProvider("https", (FileProvider)new HttpsFileProvider());
        vfs.addProvider("ftp", (FileProvider)new FtpFileProvider());
        vfs.addProvider("ftps", (FileProvider)new FtpsFileProvider());
        vfs.addProvider("war", (FileProvider)new JarFileProvider());
        vfs.addProvider("par", (FileProvider)new JarFileProvider());
        vfs.addProvider("ear", (FileProvider)new JarFileProvider());
        vfs.addProvider("sar", (FileProvider)new JarFileProvider());
        vfs.addProvider("ejb3", (FileProvider)new JarFileProvider());
        vfs.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
        vfs.addProvider("tar", (FileProvider)new TarFileProvider());
        vfs.addProvider("tbz2", (FileProvider)new TarFileProvider());
        vfs.addProvider("tgz", (FileProvider)new TarFileProvider());
        vfs.addProvider("bz2", (FileProvider)new Bzip2FileProvider());
        vfs.addProvider("hdfs", (FileProvider)new HdfsFileProvider());
        vfs.addExtensionMap("jar", "jar");
        vfs.addExtensionMap("zip", "zip");
        vfs.addExtensionMap("gz", "gz");
        vfs.addExtensionMap("tar", "tar");
        vfs.addExtensionMap("tbz2", "tar");
        vfs.addExtensionMap("tgz", "tar");
        vfs.addExtensionMap("bz2", "bz2");
        vfs.addMimeTypeMap("application/java-archive", "jar");
        vfs.addMimeTypeMap("application/x-tar", "tar");
        vfs.addMimeTypeMap("application/x-gzip", "gz");
        vfs.addMimeTypeMap("application/zip", "zip");
        vfs.setFileContentInfoFactory((FileContentInfoFactory)new FileContentInfoFilenameFactory());
        vfs.setFilesCache((FilesCache)new SoftRefFilesCache());
        File cacheDir = AccumuloVFSClassLoader.computeTopCacheDir();
        vfs.setReplicator((FileReplicator)new UniqueFileReplicator(cacheDir));
        vfs.setCacheStrategy(CacheStrategy.ON_RESOLVE);
        vfs.init();
        vfsInstances.add(new WeakReference<DefaultFileSystemManager>(vfs));
        return vfs;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="tmpdir is controlled by admin, not unchecked user input")
    private static File computeTopCacheDir() {
        String cacheDirPath = AccumuloClassLoader.getAccumuloProperty(VFS_CACHE_DIR, System.getProperty("java.io.tmpdir"));
        String procName = ManagementFactory.getRuntimeMXBean().getName();
        return new File(cacheDirPath, "accumulo-vfs-cache-" + procName + "-" + System.getProperty("user.name", "nouser"));
    }

    public static void printClassPath(boolean debug) {
        AccumuloVFSClassLoader.printClassPath(System.out::print, debug);
    }

    public static String getClassPath(boolean debug) {
        StringBuilder cp = new StringBuilder();
        AccumuloVFSClassLoader.printClassPath(cp::append, debug);
        return cp.toString();
    }

    private static void printJar(Printer out, String jarPath, boolean debug, boolean sawFirst) {
        if (debug) {
            out.print("\t");
        }
        if (!debug && sawFirst) {
            out.print(":");
        }
        out.print(jarPath);
        if (debug) {
            out.print("\n");
        }
    }

    public static void printClassPath(Printer out, boolean debug) {
        try {
            ArrayList<ClassLoader> classloaders = new ArrayList<ClassLoader>();
            for (ClassLoader cl = AccumuloVFSClassLoader.getClassLoader(); cl != null; cl = cl.getParent()) {
                classloaders.add(cl);
            }
            Collections.reverse(classloaders);
            int level = 0;
            for (ClassLoader classLoader : classloaders) {
                if (debug && ++level > 1) {
                    out.print("\n");
                }
                if (!debug && level < 2) continue;
                boolean sawFirst = false;
                String classLoaderDescription = "Level: " + level + ", Name: " + classLoader.getName() + ", class: " + classLoader.getClass().getName();
                if (classLoader.getClass().getName().startsWith("jdk.internal")) {
                    if (!debug) continue;
                    out.print(classLoaderDescription + ": configuration not inspectable.\n");
                    continue;
                }
                if (classLoader instanceof URLClassLoader) {
                    if (debug) {
                        out.print(classLoaderDescription + ": URL classpath items are:\n");
                    }
                    for (URL u : ((URLClassLoader)classLoader).getURLs()) {
                        AccumuloVFSClassLoader.printJar(out, u.getFile(), debug, sawFirst);
                        sawFirst = true;
                    }
                    continue;
                }
                if (classLoader instanceof VFSClassLoader) {
                    if (debug) {
                        out.print(classLoaderDescription + ": VFS classpaths items are:\n");
                    }
                    VFSClassLoader vcl = (VFSClassLoader)classLoader;
                    for (FileObject f : vcl.getFileObjects()) {
                        AccumuloVFSClassLoader.printJar(out, f.getURL().getFile(), debug, sawFirst);
                        sawFirst = true;
                    }
                    continue;
                }
                if (!debug) continue;
                out.print(classLoaderDescription + ": Unknown classloader: " + String.valueOf(classLoader.getClass()) + "\n");
            }
            out.print("\n");
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    public static void setContextConfig(Supplier<Map<String, String>> contextConfigSupplier, Runnable contextConfigInvalidator) {
        ContextManager.DefaultContextsConfig config = new ContextManager.DefaultContextsConfig(contextConfigSupplier, contextConfigInvalidator);
        try {
            AccumuloVFSClassLoader.getContextManager().setContextConfig(config);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void removeUnusedContexts(Set<String> contextsInUse) {
        try {
            AccumuloVFSClassLoader.getContextManager().removeUnusedContexts(contextsInUse);
        }
        catch (IOException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static ClassLoader getContextClassLoader(String contextName) throws IOException {
        return AccumuloVFSClassLoader.getContextManager().getClassLoader(contextName);
    }

    public static synchronized ContextManager getContextManager() throws IOException {
        if (contextManager == null) {
            AccumuloVFSClassLoader.getClassLoader();
            try {
                contextManager = new ContextManager(AccumuloVFSClassLoader.generateVfs(), () -> {
                    try {
                        return AccumuloVFSClassLoader.getClassLoader();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (UncheckedIOException uioe) {
                throw uioe.getCause();
            }
        }
        return contextManager;
    }

    public static void close() {
        for (WeakReference<DefaultFileSystemManager> vfsInstance : vfsInstances) {
            DefaultFileSystemManager ref = (DefaultFileSystemManager)vfsInstance.get();
            if (ref == null) continue;
            try {
                FileReplicator replicator = ref.getReplicator();
                if (replicator instanceof UniqueFileReplicator) {
                    ((UniqueFileReplicator)replicator).close();
                }
            }
            catch (FileSystemException e) {
                log.error("FileSystemException", (Throwable)e);
            }
            ref.close();
        }
        try {
            FileUtils.deleteDirectory((File)AccumuloVFSClassLoader.computeTopCacheDir());
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
    }

    static {
        log = LoggerFactory.getLogger(AccumuloVFSClassLoader.class);
        Runtime.getRuntime().addShutdownHook(new Thread(new AccumuloVFSClassLoaderShutdownThread()));
    }

    public static interface Printer {
        public void print(String var1);
    }

    public static class AccumuloVFSClassLoaderShutdownThread
    implements Runnable {
        @Override
        public void run() {
            try {
                AccumuloVFSClassLoader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

