/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteShellOptions {
    private static final Logger log = LoggerFactory.getLogger(RemoteShellOptions.class);
    public static final String SSH_PREFIX = "accumulo.cluster.ssh.";
    public static final String SSH_COMMAND_KEY = "accumulo.cluster.ssh.command";
    public static final String SSH_COMMAND_DEFAULT = "/usr/bin/ssh";
    public static final String SSH_OPTIONS_KEY = "accumulo.cluster.ssh.options";
    public static final String SSH_OPTIONS_DEFAULT = "-o StrictHostKeyChecking=no";
    public static final String SSH_USER_KEY = "accumulo.cluster.ssh.user";
    public static final String SSH_USER_DEFAULT = "";
    public static final String SSH_PROPERTIES_FILE = "accumulo.ssh.properties";
    protected Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    public RemoteShellOptions() {
        File f;
        String propertyFile = System.getProperty(SSH_PROPERTIES_FILE);
        if (propertyFile != null && (f = new File(propertyFile)).exists() && f.isFile() && f.canRead()) {
            FileReader reader = null;
            try {
                reader = new FileReader(f, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.warn("Could not read properties from specified file: {}", (Object)propertyFile, (Object)e);
            }
            if (reader != null) {
                try {
                    this.properties.load(reader);
                }
                catch (IOException e) {
                    log.warn("Could not load properties from specified file: {}", (Object)propertyFile, (Object)e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.warn("Could not close reader", (Throwable)e);
                    }
                }
            }
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(key = (String)entry.getKey()).startsWith(SSH_PREFIX)) continue;
            this.properties.put(key, entry.getValue());
        }
    }

    public String getUserName() {
        return this.properties.getProperty(SSH_USER_KEY, SSH_USER_DEFAULT);
    }

    public String getSshOptions() {
        return this.properties.getProperty(SSH_OPTIONS_KEY, SSH_OPTIONS_DEFAULT);
    }

    public String getSshCommand() {
        return this.properties.getProperty(SSH_COMMAND_KEY, SSH_COMMAND_DEFAULT);
    }
}

