/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.replication;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.replication.ReplicationInformation;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.replication.ReplicaSystem;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/replication")
@Produces(value={"application/json", "application/xml"})
@Deprecated
public class ReplicationResource {
    private static final Logger log = LoggerFactory.getLogger(ReplicationResource.class);
    @Inject
    private Monitor monitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public List<ReplicationInformation> getReplicationInformation() throws AccumuloException, AccumuloSecurityException {
        BatchScanner bs;
        ServerContext client = this.monitor.getContext();
        TableOperations tops = client.tableOperations();
        Map properties = client.instanceOperations().getSystemConfiguration();
        HashMap<String, String> peers = new HashMap<String, String>();
        String definedPeersPrefix = Property.REPLICATION_PEERS.getKey();
        ReplicaSystemFactory replicaSystemFactory = new ReplicaSystemFactory();
        for (Map.Entry property : properties.entrySet()) {
            ReplicaSystem replica;
            String key2 = (String)property.getKey();
            if (!key2.startsWith(definedPeersPrefix) || key2.startsWith(Property.REPLICATION_PEER_USER.getKey()) || key2.startsWith(Property.REPLICATION_PEER_PASSWORD.getKey())) continue;
            String peerName = ((String)property.getKey()).substring(definedPeersPrefix.length());
            try {
                replica = replicaSystemFactory.get(this.monitor.getContext(), (String)property.getValue());
            }
            catch (Exception e) {
                log.warn("Could not instantiate ReplicaSystem for {} with configuration {}", new Object[]{property.getKey(), property.getValue(), e});
                continue;
            }
            peers.put(peerName, replica.getClass().getName());
        }
        String targetPrefix = Property.TABLE_REPLICATION_TARGET.getKey();
        HashSet allConfiguredTargets = new HashSet();
        HashMap<ReplicationTarget, Long> targetCounts = new HashMap<ReplicationTarget, Long>();
        Map tableNameToId = this.monitor.getContext().getTableNameToIdMap();
        Map<TableId, String> tableIdToName = this.invert(tableNameToId);
        for (String table : tops.list()) {
            Map propertiesForTable;
            if (MetadataTable.NAME.equals(table) || RootTable.NAME.equals(table)) continue;
            TableId localId = (TableId)tableNameToId.get(table);
            if (localId == null) {
                log.trace("Could not determine ID for {}", (Object)table);
                continue;
            }
            try {
                propertiesForTable = tops.getConfiguration(table);
            }
            catch (TableNotFoundException e) {
                log.warn("Could not fetch properties for {}", (Object)table, (Object)e);
                continue;
            }
            propertiesForTable.forEach((key, value) -> {
                if (key.startsWith(targetPrefix)) {
                    String peerName = key.substring(targetPrefix.length());
                    String remoteIdentifier = value;
                    ReplicationTarget target = new ReplicationTarget(peerName, remoteIdentifier, localId);
                    allConfiguredTargets.add(target);
                }
            });
        }
        if (!ReplicationTable.isOnline((AccumuloClient)client)) {
            log.debug("Replication page requested, but replication table is offline");
            return Collections.emptyList();
        }
        try {
            bs = client.createBatchScanner(ReplicationTable.NAME, Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException | TableOfflineException e) {
            log.error("Could not read replication table", e);
            return Collections.emptyList();
        }
        bs.setRanges(Collections.singleton(new Range()));
        ReplicationSchema.WorkSection.limit((ScannerBase)bs);
        try {
            Text buffer = new Text();
            for (Map.Entry entry : bs) {
                Key k = (Key)entry.getKey();
                k.getColumnQualifier(buffer);
                ReplicationTarget target = ReplicationTarget.from((Text)buffer);
                Long count = (Long)targetCounts.get(target);
                if (count == null) {
                    targetCounts.put(target, 1L);
                    continue;
                }
                targetCounts.put(target, count + 1L);
            }
        }
        finally {
            bs.close();
        }
        ArrayList<ReplicationInformation> replicationInformation = new ArrayList<ReplicationInformation>();
        for (ReplicationTarget configuredTarget : allConfiguredTargets) {
            String tableName = tableIdToName.get(configuredTarget.getSourceTableId());
            if (tableName == null) {
                log.trace("Could not determine table name from id {}", (Object)configuredTarget.getSourceTableId());
                continue;
            }
            String replicaSystemClass = (String)peers.get(configuredTarget.getPeerName());
            if (replicaSystemClass == null) {
                log.trace("Could not determine configured ReplicaSystem for {}", (Object)configuredTarget.getPeerName());
                continue;
            }
            Long numFiles = (Long)targetCounts.get(configuredTarget);
            replicationInformation.add(new ReplicationInformation(tableName, configuredTarget.getPeerName(), configuredTarget.getRemoteIdentifier(), replicaSystemClass, numFiles == null ? 0L : numFiles));
        }
        return replicationInformation;
    }

    protected Map<TableId, String> invert(Map<String, TableId> map) {
        HashMap<TableId, String> newMap = new HashMap<TableId, String>(map.size());
        for (Map.Entry<String, TableId> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }
}

