/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import jakarta.inject.Singleton;
import jakarta.servlet.Servlet;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ServiceLockSupport;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.Timer;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.monitor.EmbeddedWebServer;
import org.apache.accumulo.monitor.rest.compactions.external.ExternalCompactionInfo;
import org.apache.accumulo.monitor.rest.compactions.external.RunningCompactions;
import org.apache.accumulo.monitor.rest.compactions.external.RunningCompactorDetails;
import org.apache.accumulo.monitor.util.logging.RecentLogs;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.HighlyAvailableService;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.thrift.TServiceClient;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor
extends AbstractServer
implements HighlyAvailableService {
    private static final Logger log = LoggerFactory.getLogger(Monitor.class);
    private static final int REFRESH_TIME = 5;
    private final long START_TIME;
    private final AtomicLong lastRecalc = new AtomicLong(0L);
    private double totalIngestRate = 0.0;
    private double totalQueryRate = 0.0;
    private double totalScanRate = 0.0;
    private long totalEntries = 0L;
    private int totalTabletCount = 0;
    private long totalHoldTime = 0L;
    private long totalLookups = 0L;
    private int totalTables = 0;
    private final AtomicBoolean monitorInitialized = new AtomicBoolean(false);
    private final List<Pair<Long, Double>> loadOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> ingestRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> ingestByteRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> minorCompactionsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Integer>> majorCompactionsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> lookupsOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Long>> queryRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Long>> scanRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> queryByteRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> indexCacheHitRateOverTime = Monitor.newMaxList();
    private final List<Pair<Long, Double>> dataCacheHitRateOverTime = Monitor.newMaxList();
    private EventCounter lookupRateTracker = new EventCounter();
    private EventCounter indexCacheHitTracker = new EventCounter();
    private EventCounter indexCacheRequestTracker = new EventCounter();
    private EventCounter dataCacheHitTracker = new EventCounter();
    private EventCounter dataCacheRequestTracker = new EventCounter();
    private final AtomicBoolean fetching = new AtomicBoolean(false);
    private ManagerMonitorInfo mmi;
    private Map<TableId, Map<ProblemType, Integer>> problemSummary = Collections.emptyMap();
    private Exception problemException;
    private GCStatus gcStatus;
    private Optional<HostAndPort> coordinatorHost = Optional.empty();
    private Timer coordinatorCheck = null;
    private CompactionCoordinatorService.Client coordinatorClient;
    private final String coordinatorMissingMsg = "Error getting the compaction coordinator. Check that it is running. It is not started automatically with other cluster processes so must be started by running 'accumulo compaction-coordinator'.";
    private EmbeddedWebServer server;
    private int livePort = 0;
    private ServiceLock monitorLock;
    private final long expirationTimeMinutes = 1L;
    private final Supplier<Map<HostAndPort, ScanStats>> tserverScansSupplier = Suppliers.memoizeWithExpiration(this::fetchTServerScans, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    private final Supplier<Map<HostAndPort, ScanStats>> sserverScansSupplier = Suppliers.memoizeWithExpiration(this::fetchSServerScans, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    private final Supplier<Map<HostAndPort, CompactionStats>> compactionsSupplier = Suppliers.memoizeWithExpiration(this::fetchCompactions, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    private final Supplier<ExternalCompactionInfo> compactorInfoSupplier = Suppliers.memoizeWithExpiration(this::fetchCompactorsInfo, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    private final Supplier<ExternalCompactionsSnapshot> externalCompactionsSupplier = Suppliers.memoizeWithExpiration(this::computeExternalCompactionsSnapshot, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    private final RecentLogs recentLogs = new RecentLogs();

    public static void main(String[] args) throws Exception {
        try (Monitor monitor = new Monitor(new ServerOpts(), args);){
            monitor.runServer();
        }
    }

    Monitor(ServerOpts opts, String[] args) {
        super("monitor", opts, args);
        this.START_TIME = System.currentTimeMillis();
    }

    private static <T> List<Pair<Long, T>> newMaxList() {
        return Collections.synchronizedList(new LinkedList<Pair<Long, T>>(){
            private static final long serialVersionUID = 1L;
            private final long maxDelta = TimeUnit.HOURS.toMillis(1L);

            @Override
            public boolean add(Pair<Long, T> obj) {
                boolean result = super.add(obj);
                if ((Long)obj.getFirst() - (Long)((Pair)this.get(0)).getFirst() > this.maxDelta) {
                    this.remove(0);
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchData() {
        ServerContext context = this.getContext();
        double totalIngestRate = 0.0;
        double totalIngestByteRate = 0.0;
        double totalQueryRate = 0.0;
        double totalQueryByteRate = 0.0;
        double totalScanRate = 0.0;
        long totalEntries = 0L;
        int totalTabletCount = 0;
        long totalHoldTime = 0L;
        long totalLookups = 0L;
        boolean retry = true;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRecalc.get() < 5000L) {
            return;
        }
        if (!this.fetching.compareAndSet(false, true)) {
            return;
        }
        try {
            while (retry) {
                ManagerClientService.Client client = null;
                try {
                    client = ThriftClientTypes.MANAGER.getConnection((ClientContext)context);
                    if (client != null) {
                        this.mmi = client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds());
                        retry = false;
                    } else {
                        this.mmi = null;
                        log.error("Unable to get info from Manager");
                    }
                    this.gcStatus = this.fetchGcStatus();
                }
                catch (Exception e) {
                    this.mmi = null;
                    log.info("Error fetching stats: ", (Throwable)e);
                }
                finally {
                    if (client != null) {
                        ThriftUtil.close((TServiceClient)client, (ClientContext)context);
                    }
                }
                if (this.mmi != null) continue;
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (this.mmi != null) {
                int majorCompactions = 0;
                int minorCompactions = 0;
                this.lookupRateTracker.startingUpdates();
                this.indexCacheHitTracker.startingUpdates();
                this.indexCacheRequestTracker.startingUpdates();
                this.dataCacheHitTracker.startingUpdates();
                this.dataCacheRequestTracker.startingUpdates();
                for (Object server : this.mmi.tServerInfo) {
                    TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)server);
                    totalIngestRate += summary.ingestRate;
                    totalIngestByteRate += summary.ingestByteRate;
                    totalQueryRate += summary.queryRate;
                    totalScanRate += summary.scanRate;
                    totalQueryByteRate += summary.queryByteRate;
                    totalEntries += summary.recs;
                    totalHoldTime += ((TabletServerStatus)server).holdTime;
                    totalLookups += ((TabletServerStatus)server).lookups;
                    majorCompactions += summary.majors.running;
                    minorCompactions += summary.minors.running;
                    this.lookupRateTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).lookups);
                    this.indexCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheHits);
                    this.indexCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheRequest);
                    this.dataCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheHits);
                    this.dataCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheRequest);
                }
                this.lookupRateTracker.finishedUpdating();
                this.indexCacheHitTracker.finishedUpdating();
                this.indexCacheRequestTracker.finishedUpdating();
                this.dataCacheHitTracker.finishedUpdating();
                this.dataCacheRequestTracker.finishedUpdating();
                int totalTables = 0;
                for (TableInfo tInfo : this.mmi.tableMap.values()) {
                    totalTabletCount += tInfo.tablets;
                    ++totalTables;
                }
                this.totalIngestRate = totalIngestRate;
                this.totalTables = totalTables;
                totalIngestByteRate /= 1000000.0;
                this.totalQueryRate = totalQueryRate;
                this.totalScanRate = totalScanRate;
                totalQueryByteRate /= 1000000.0;
                this.totalEntries = totalEntries;
                this.totalTabletCount = totalTabletCount;
                this.totalHoldTime = totalHoldTime;
                this.totalLookups = totalLookups;
                this.ingestRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestRate));
                this.ingestByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestByteRate));
                double totalLoad = 0.0;
                for (TabletServerStatus status : this.mmi.tServerInfo) {
                    if (status == null) continue;
                    totalLoad += status.osLoad;
                }
                this.loadOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalLoad));
                this.minorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)minorCompactions));
                this.majorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)majorCompactions));
                this.lookupsOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)this.lookupRateTracker.calculateRate()));
                this.queryRateOverTime.add((Pair<Long, Long>)new Pair((Object)currentTime, (Object)((long)totalQueryRate)));
                this.queryByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalQueryByteRate));
                this.scanRateOverTime.add((Pair<Long, Long>)new Pair((Object)currentTime, (Object)((long)totalScanRate)));
                Monitor.calcCacheHitRate(this.indexCacheHitRateOverTime, currentTime, this.indexCacheHitTracker, this.indexCacheRequestTracker);
                Monitor.calcCacheHitRate(this.dataCacheHitRateOverTime, currentTime, this.dataCacheHitTracker, this.dataCacheRequestTracker);
            }
            try {
                this.problemSummary = ProblemReports.getInstance((ServerContext)context).summarize();
                this.problemException = null;
            }
            catch (Exception e) {
                log.info("Failed to obtain problem reports ", (Throwable)e);
                this.problemSummary = Collections.emptyMap();
                this.problemException = e;
            }
            if (this.coordinatorCheck == null || this.coordinatorCheck.hasElapsed(1L, TimeUnit.MINUTES)) {
                Optional<HostAndPort> previousHost = this.coordinatorHost;
                this.coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)context);
                this.coordinatorCheck = Timer.startNew();
                if (previousHost.isEmpty() && this.coordinatorHost.isPresent()) {
                    log.info("External Compaction Coordinator found at {}", (Object)this.coordinatorHost.orElseThrow());
                }
            }
        }
        finally {
            if (this.coordinatorClient != null) {
                ThriftUtil.returnClient((TServiceClient)this.coordinatorClient, (ClientContext)context);
                this.coordinatorClient = null;
            }
            this.lastRecalc.set(currentTime);
            if (!this.fetching.compareAndSet(true, false)) {
                throw new AssertionError((Object)"Not supposed to happen; somebody broke this code");
            }
        }
    }

    private static void calcCacheHitRate(List<Pair<Long, Double>> hitRate, long currentTime, EventCounter cacheHits, EventCounter cacheReq) {
        long req = cacheReq.calculateCount();
        if (req > 0L) {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)((double)cacheHits.calculateCount() / (double)cacheReq.calculateCount())));
        } else {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GCStatus fetchGcStatus() {
        GCStatus result;
        block5: {
            ServerContext context = this.getContext();
            result = null;
            HostAndPort address = null;
            try {
                ZooReaderWriter zk = context.getZooReaderWriter();
                ServiceLock.ServiceLockPath path = ServiceLock.path((String)(context.getZooKeeperRoot() + "/gc/lock"));
                List locks = ServiceLock.validateAndSort((ServiceLock.ServiceLockPath)path, (List)zk.getChildren(path.toString()));
                if (locks == null || locks.isEmpty()) break block5;
                address = new ServerServices(new String(zk.getData(String.valueOf(path) + "/" + (String)locks.get(0)), StandardCharsets.UTF_8)).getAddress(ServerServices.Service.GC_CLIENT);
                GCMonitorService.Client client = (GCMonitorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.GC, (HostAndPort)address, (ClientContext)context);
                try {
                    result = client.getStatus(TraceUtil.traceInfo(), context.rpcCreds());
                }
                finally {
                    ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
                }
            }
            catch (Exception ex) {
                log.warn("Unable to contact the garbage collector at " + String.valueOf(address), (Throwable)ex);
            }
        }
        return result;
    }

    public void run() {
        ServerContext context = this.getContext();
        int[] ports = this.getConfiguration().getPort(Property.MONITOR_PORT);
        Object rootContext = this.getConfiguration().get(Property.MONITOR_ROOT_CONTEXT);
        Preconditions.checkArgument((boolean)((String)rootContext).startsWith("/"), (String)"Root context: \"%s\" does not have a leading '/'", (Object)rootContext);
        for (int port : ports) {
            try {
                log.debug("Trying monitor on port {}", (Object)port);
                this.server = new EmbeddedWebServer(this, port);
                this.server.addServlet(this.getDefaultServlet(), "/resources/*");
                this.server.addServlet(this.getRestServlet(), "/rest/*");
                this.server.addServlet(this.getViewServlet(), "/*");
                this.server.start();
                this.livePort = port;
                break;
            }
            catch (Exception ex) {
                log.error("Unable to start embedded web server", (Throwable)ex);
            }
        }
        if (!this.server.isRunning()) {
            throw new RuntimeException("Unable to start embedded web server on ports: " + Arrays.toString(ports));
        }
        log.debug("Monitor listening on {}:{}", (Object)this.server.getHostName(), (Object)this.livePort);
        try {
            this.getMonitorLock();
        }
        catch (Exception e) {
            log.error("Failed to get Monitor ZooKeeper lock");
            throw new RuntimeException(e);
        }
        HostAndPort advertiseAddress = this.getAdvertiseAddress();
        if (advertiseAddress == null) {
            String advertiseHost = this.server.getHostName();
            if (advertiseHost == null || advertiseHost == "0.0.0.0") {
                try {
                    advertiseHost = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException("Unable to get hostname for advertise address", e);
                }
            }
            this.updateAdvertiseAddress(HostAndPort.fromParts((String)advertiseHost, (int)this.livePort));
        } else {
            this.updateAdvertiseAddress(HostAndPort.fromParts((String)advertiseAddress.getHost(), (int)this.livePort));
        }
        HostAndPort monitorHostAndPort = this.getAdvertiseAddress();
        log.debug("Using {} to advertise monitor location in ZooKeeper", (Object)monitorHostAndPort);
        try {
            this.monitorLock.replaceLockData(monitorHostAndPort.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Exception updating monitor lock with host and port", e);
        }
        MetricsInfo metricsInfo = this.getContext().getMetricsInfo();
        metricsInfo.init(MetricsInfo.serviceTags((String)this.getContext().getInstanceName(), (String)this.getApplicationName(), (HostAndPort)monitorHostAndPort, (String)""));
        if (!((String)rootContext).endsWith("/")) {
            rootContext = (String)rootContext + "/";
        }
        try {
            URL url = new URL(this.server.isSecure() ? "https" : "http", monitorHostAndPort.getHost(), this.server.getPort(), (String)rootContext);
            String path = context.getZooKeeperRoot() + "/monitor/http_addr";
            ZooReaderWriter zoo = context.getZooReaderWriter();
            zoo.delete(path);
            zoo.putEphemeralData(path, url.toString().getBytes(StandardCharsets.UTF_8));
            log.info("Set monitor address in zookeeper to {}", (Object)url);
        }
        catch (Exception ex) {
            log.error("Unable to advertise monitor HTTP address in zookeeper", (Throwable)ex);
        }
        Threads.createCriticalThread((String)"Data fetcher", () -> {
            while (true) {
                try {
                    this.fetchData();
                }
                catch (Exception e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
                UtilWaitThread.sleepUninterruptibly((long)333L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }).start();
        this.monitorInitialized.set(true);
        while (!this.isShutdownRequested()) {
            if (Thread.currentThread().isInterrupted()) {
                LOG.info("Server process thread has been interrupted, shutting down");
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupt Exception received, shutting down");
                this.gracefulShutdown(context.rpcCreds());
            }
        }
        this.server.stop();
        log.info("stop requested. exiting ... ");
    }

    private ServletHolder getDefaultServlet() {
        return new ServletHolder((Servlet)new DefaultServlet(){
            private static final long serialVersionUID = 1L;

            public Resource getResource(String pathInContext) {
                return Resource.newClassPathResource((String)("/org/apache/accumulo/monitor" + pathInContext));
            }
        });
    }

    private ServletHolder getViewServlet() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"org.apache.accumulo.monitor.view"}).register((Object)new MonitorFactory(this)).register((Object)new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()))).register(FreemarkerMvcFeature.class).property("jersey.config.server.mvc.templateBasePath", (Object)"/org/apache/accumulo/monitor/templates");
        return new ServletHolder((Servlet)new ServletContainer(rc));
    }

    private ServletHolder getRestServlet() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"org.apache.accumulo.monitor.rest"}).register((Object)new MonitorFactory(this)).register((Object)new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()))).register(JacksonFeature.class);
        return new ServletHolder((Servlet)new ServletContainer(rc));
    }

    public Map<HostAndPort, ScanStats> getScans() {
        return this.tserverScansSupplier.get();
    }

    public Map<HostAndPort, ScanStats> getScanServerScans() {
        return this.sserverScansSupplier.get();
    }

    public Map<HostAndPort, CompactionStats> getCompactions() {
        return this.compactionsSupplier.get();
    }

    public ExternalCompactionInfo getCompactorsInfo() {
        if (this.coordinatorHost.isEmpty()) {
            throw new IllegalStateException("Tried fetching from compaction coordinator that's missing");
        }
        return this.compactorInfoSupplier.get();
    }

    public RunningCompactions getRunningCompactions() {
        return this.externalCompactionsSupplier.get().runningCompactions;
    }

    public RunningCompactorDetails getRunningCompactorDetails(ExternalCompactionId ecid) {
        TExternalCompaction extCompaction = this.externalCompactionsSupplier.get().ecRunningMap.get(ecid.canonical());
        if (extCompaction == null) {
            return null;
        }
        return new RunningCompactorDetails(extCompaction);
    }

    private CompactionCoordinatorService.Client getCoordinator(HostAndPort address) {
        if (this.coordinatorClient == null) {
            try {
                this.coordinatorClient = (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)address, (ClientContext)this.getContext());
            }
            catch (Exception e) {
                log.error("Unable to get Compaction coordinator at {}", (Object)address);
                throw new IllegalStateException("Error getting the compaction coordinator. Check that it is running. It is not started automatically with other cluster processes so must be started by running 'accumulo compaction-coordinator'.", e);
            }
        }
        return this.coordinatorClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<HostAndPort, ScanStats> fetchScans(Collection<String> servers) {
        ServerContext context = this.getContext();
        HashMap<HostAndPort, ScanStats> scans = new HashMap<HostAndPort, ScanStats>();
        for (String server : servers) {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletScanClientService.Client client = null;
            try {
                client = (TabletScanClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SCAN, (HostAndPort)parsedServer, (ClientContext)context);
                List activeScans = client.getActiveScans(null, context.rpcCreds());
                scans.put(parsedServer, new ScanStats(activeScans));
            }
            catch (Exception ex) {
                try {
                    log.error("Failed to get active scans from {}", (Object)server, (Object)ex);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(client, (ClientContext)context);
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
        }
        return Collections.unmodifiableMap(scans);
    }

    private Map<HostAndPort, ScanStats> fetchTServerScans() {
        return this.fetchScans(this.getContext().instanceOperations().getTabletServers());
    }

    private Map<HostAndPort, ScanStats> fetchSServerScans() {
        return this.fetchScans(this.getContext().instanceOperations().getScanServers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<HostAndPort, CompactionStats> fetchCompactions() {
        ServerContext context = this.getContext();
        HashMap<HostAndPort, CompactionStats> allCompactions = new HashMap<HostAndPort, CompactionStats>();
        for (String server : context.instanceOperations().getTabletServers()) {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletClientService.Client tserver = null;
            try {
                tserver = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)parsedServer, (ClientContext)context);
                List compacts = tserver.getActiveCompactions(null, context.rpcCreds());
                allCompactions.put(parsedServer, new CompactionStats(compacts));
            }
            catch (Exception ex) {
                try {
                    log.debug("Failed to get active compactions from {}", (Object)server, (Object)ex);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(tserver, (ClientContext)context);
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)tserver, (ClientContext)context);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)tserver, (ClientContext)context);
        }
        return Collections.unmodifiableMap(allCompactions);
    }

    private ExternalCompactionInfo fetchCompactorsInfo() {
        ServerContext context = this.getContext();
        Map compactors = ExternalCompactionUtil.getCompactorAddrs((ClientContext)context);
        log.debug("Found compactors: {}", (Object)compactors);
        ExternalCompactionInfo ecInfo = new ExternalCompactionInfo();
        ecInfo.setFetchedTimeMillis(System.currentTimeMillis());
        ecInfo.setCompactors(compactors);
        ecInfo.setCoordinatorHost(this.coordinatorHost);
        return ecInfo;
    }

    private ExternalCompactionsSnapshot computeExternalCompactionsSnapshot() {
        TExternalCompactionList running;
        if (this.coordinatorHost.isEmpty()) {
            throw new IllegalStateException("Error getting the compaction coordinator. Check that it is running. It is not started automatically with other cluster processes so must be started by running 'accumulo compaction-coordinator'.");
        }
        HostAndPort ccHost = this.coordinatorHost.orElseThrow();
        log.info("User initiated fetch of running External Compactions from " + String.valueOf(ccHost));
        CompactionCoordinatorService.Client client = this.getCoordinator(ccHost);
        try {
            running = client.getRunningCompactions(TraceUtil.traceInfo(), this.getContext().rpcCreds());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get running compactions from " + String.valueOf(ccHost), e);
        }
        return new ExternalCompactionsSnapshot(Optional.ofNullable(running.getCompactions()));
    }

    private void getMonitorLock() throws KeeperException, InterruptedException {
        ServerContext context = this.getContext();
        String zRoot = context.getZooKeeperRoot();
        String monitorPath = zRoot + "/monitor";
        ServiceLock.ServiceLockPath monitorLockPath = ServiceLock.path((String)(zRoot + "/monitor/lock"));
        ZooReaderWriter zoo = context.getZooReaderWriter();
        if (zoo.exists(monitorPath)) {
            byte[] data = zoo.getData(monitorPath);
            if (data.length != 0) {
                zoo.recursiveDelete(monitorPath, ZooUtil.NodeMissingPolicy.SKIP);
                zoo.putPersistentData(monitorPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
                zoo.putPersistentData(monitorLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            } else if (!zoo.exists(monitorLockPath.toString())) {
                zoo.putPersistentData(monitorLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        } else {
            zoo.putPersistentData(zRoot + "/monitor", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            if (!zoo.exists(monitorLockPath.toString())) {
                zoo.putPersistentData(monitorLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        }
        UUID zooLockUUID = UUID.randomUUID();
        this.monitorLock = new ServiceLock(zoo.getZooKeeper(), monitorLockPath, zooLockUUID);
        ServiceLockSupport.HAServiceLockWatcher monitorLockWatcher = new ServiceLockSupport.HAServiceLockWatcher("monitor", () -> this.isShutdownRequested());
        while (true) {
            this.monitorLock.lock((ServiceLock.AccumuloLockWatcher)monitorLockWatcher, new byte[0]);
            monitorLockWatcher.waitForChange();
            if (monitorLockWatcher.isLockAcquired()) break;
            if (!monitorLockWatcher.isFailedToAcquireLock()) {
                throw new IllegalStateException("monitor lock in unknown state");
            }
            this.monitorLock.tryToCancelAsyncLockOrUnlock();
            UtilWaitThread.sleepUninterruptibly((long)context.getConfiguration().getTimeInMillis(Property.MONITOR_LOCK_CHECK_INTERVAL), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("Got Monitor lock.");
    }

    public ManagerMonitorInfo getMmi() {
        return this.mmi;
    }

    public int getTotalTables() {
        return this.totalTables;
    }

    public int getTotalTabletCount() {
        return this.totalTabletCount;
    }

    public long getTotalEntries() {
        return this.totalEntries;
    }

    public double getTotalIngestRate() {
        return this.totalIngestRate;
    }

    public double getTotalQueryRate() {
        return this.totalQueryRate;
    }

    public double getTotalScanRate() {
        return this.totalScanRate;
    }

    public long getTotalHoldTime() {
        return this.totalHoldTime;
    }

    public Exception getProblemException() {
        return this.problemException;
    }

    public Map<TableId, Map<ProblemType, Integer>> getProblemSummary() {
        return this.problemSummary;
    }

    public GCStatus getGcStatus() {
        return this.gcStatus;
    }

    public long getTotalLookups() {
        return this.totalLookups;
    }

    public long getStartTime() {
        return this.START_TIME;
    }

    public List<Pair<Long, Double>> getLoadOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.loadOverTime);
    }

    public List<Pair<Long, Double>> getIngestRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.ingestRateOverTime);
    }

    public List<Pair<Long, Double>> getIngestByteRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.ingestByteRateOverTime);
    }

    public List<Pair<Long, Integer>> getMinorCompactionsOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.minorCompactionsOverTime);
    }

    public List<Pair<Long, Integer>> getMajorCompactionsOverTime() {
        return new ArrayList<Pair<Long, Integer>>(this.majorCompactionsOverTime);
    }

    public List<Pair<Long, Double>> getLookupsOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.lookupsOverTime);
    }

    public double getLookupRate() {
        return this.lookupRateTracker.calculateRate();
    }

    public List<Pair<Long, Long>> getQueryRateOverTime() {
        return new ArrayList<Pair<Long, Long>>(this.queryRateOverTime);
    }

    public List<Pair<Long, Long>> getScanRateOverTime() {
        return new ArrayList<Pair<Long, Long>>(this.scanRateOverTime);
    }

    public List<Pair<Long, Double>> getQueryByteRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.queryByteRateOverTime);
    }

    public List<Pair<Long, Double>> getIndexCacheHitRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.indexCacheHitRateOverTime);
    }

    public List<Pair<Long, Double>> getDataCacheHitRateOverTime() {
        return new ArrayList<Pair<Long, Double>>(this.dataCacheHitRateOverTime);
    }

    public boolean isActiveService() {
        return this.monitorInitialized.get();
    }

    public RecentLogs recentLogs() {
        return this.recentLogs;
    }

    public Optional<HostAndPort> getCoordinatorHost() {
        return this.coordinatorHost;
    }

    public int getLivePort() {
        return this.livePort;
    }

    public ServiceLock getLock() {
        return this.monitorLock;
    }

    private static class EventCounter {
        Map<String, Pair<Long, Long>> prevSamples = new HashMap<String, Pair<Long, Long>>();
        Map<String, Pair<Long, Long>> samples = new HashMap<String, Pair<Long, Long>>();
        Set<String> serversUpdated = new HashSet<String>();

        private EventCounter() {
        }

        synchronized void startingUpdates() {
            this.serversUpdated.clear();
        }

        synchronized void updateTabletServer(String name, long sampleTime, long numEvents) {
            Pair newSample = new Pair((Object)sampleTime, (Object)numEvents);
            Pair<Long, Long> lastSample = this.samples.get(name);
            if (lastSample == null || !lastSample.equals((Object)newSample)) {
                this.samples.put(name, (Pair<Long, Long>)newSample);
                if (lastSample != null) {
                    this.prevSamples.put(name, lastSample);
                }
            }
            this.serversUpdated.add(name);
        }

        synchronized void finishedUpdating() {
            this.samples.keySet().retainAll(this.serversUpdated);
            this.prevSamples.keySet().retainAll(this.serversUpdated);
        }

        synchronized double calculateRate() {
            double totalRate = 0.0;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                totalRate += (double)((Long)sample.getSecond() - (Long)prevSample.getSecond()) / ((double)((Long)sample.getFirst() - (Long)prevSample.getFirst()) / 1000.0);
            }
            return totalRate;
        }

        synchronized long calculateCount() {
            long count = 0L;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                count += (Long)sample.getSecond() - (Long)prevSample.getSecond();
            }
            return count;
        }
    }

    public static class MonitorFactory
    extends AbstractBinder
    implements Factory<Monitor> {
        private final Monitor monitor;

        public MonitorFactory(Monitor monitor) {
            this.monitor = monitor;
        }

        public Monitor provide() {
            return this.monitor;
        }

        public void dispose(Monitor instance) {
        }

        protected void configure() {
            this.bindFactory(this).to(Monitor.class).in(Singleton.class);
        }
    }

    private static class ExternalCompactionsSnapshot {
        public final RunningCompactions runningCompactions;
        public final Map<String, TExternalCompaction> ecRunningMap;

        private ExternalCompactionsSnapshot(Optional<Map<String, TExternalCompaction>> ecRunningMapOpt) {
            this.ecRunningMap = ecRunningMapOpt.map(Collections::unmodifiableMap).orElse(Collections.emptyMap());
            this.runningCompactions = new RunningCompactions(this.ecRunningMap);
        }
    }

    public static class ScanStats {
        public final long scanCount;
        public final Long oldestScan;
        public final long fetched;

        ScanStats(List<ActiveScan> active) {
            this.scanCount = active.size();
            long oldest = -1L;
            for (ActiveScan scan : active) {
                oldest = Math.max(oldest, scan.age);
            }
            this.oldestScan = oldest < 0L ? null : Long.valueOf(oldest);
            this.fetched = System.currentTimeMillis();
        }
    }

    public static class CompactionStats {
        public final long count;
        public final Long oldest;
        public final long fetched;

        CompactionStats(List<ActiveCompaction> active) {
            this.count = active.size();
            long oldest = -1L;
            for (ActiveCompaction a : active) {
                oldest = Math.max(oldest, a.age);
            }
            this.oldest = oldest < 0L ? null : Long.valueOf(oldest);
            this.fetched = System.currentTimeMillis();
        }
    }
}

