/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSummary;

public final class Sketches {
    public static <S extends Summary> Sketch<S> createEmptySketch() {
        return new CompactSketch(null, null, Long.MAX_VALUE, true);
    }

    public static <S extends Summary> Sketch<S> heapifySketch(Memory mem, SummaryDeserializer<S> deserializer) {
        SerializerDeserializer.SketchType sketchType = SerializerDeserializer.getSketchType(mem);
        if (sketchType == SerializerDeserializer.SketchType.QuickSelectSketch) {
            return new QuickSelectSketch<S>(mem, deserializer, null);
        }
        return new CompactSketch<S>(mem, deserializer);
    }

    @Deprecated
    public static <U, S extends UpdatableSummary<U>> UpdatableSketch<U, S> heapifyUpdatableSketch(Memory mem, SummaryDeserializer<S> deserializer, SummaryFactory<S> summaryFactory) {
        return new UpdatableSketch(mem, deserializer, summaryFactory);
    }
}

