/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.QuotedStringTokenizer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class ShellCompletor
implements Completer {
    Map<Shell.Command.CompletionSet, Set<String>> options;
    Token root = null;

    public ShellCompletor() {
    }

    public ShellCompletor(Token rootToken, Map<Shell.Command.CompletionSet, Set<String>> options) {
        this.root = rootToken;
        this.options = options;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        try {
            ArrayList<String> strings = new ArrayList<String>();
            this._complete(line.line(), line.cursor(), strings);
            for (String str : strings) {
                candidates.add(new Candidate(str));
            }
        }
        catch (Exception e) {
            candidates.add(new Candidate(""));
            candidates.add(new Candidate(e.getMessage()));
        }
    }

    private int _complete(String fullBuffer, int cursor, List<String> candidates) {
        boolean inTableFlag = false;
        boolean inUserFlag = false;
        boolean inNamespaceFlag = false;
        String buffer = fullBuffer.substring(0, cursor);
        Token current_command_token = this.root;
        String current_string_token = null;
        boolean end_space = buffer.endsWith(" ");
        if (buffer.isEmpty()) {
            candidates.addAll(this.root.getSubcommandNames());
            return 0;
        }
        Object prefix = "";
        QuotedStringTokenizer qst = new QuotedStringTokenizer(buffer);
        Iterator<String> iter = qst.iterator();
        while (iter.hasNext()) {
            current_string_token = iter.next();
            current_string_token = current_string_token.replaceAll("([\\s'\"])", "\\\\$1");
            if (!iter.hasNext()) {
                if (end_space && !current_string_token.endsWith(" ") || buffer.endsWith("\"")) {
                    Token next;
                    if (current_string_token.trim().equals("-t")) {
                        candidates.addAll((Collection<String>)this.options.get((Object)Shell.Command.CompletionSet.TABLENAMES));
                        prefix = (String)prefix + "-t ";
                    } else if (current_string_token.trim().equals("-u")) {
                        candidates.addAll((Collection<String>)this.options.get((Object)Shell.Command.CompletionSet.USERNAMES));
                        prefix = (String)prefix + "-u ";
                    } else if (current_string_token.trim().equals("-ns")) {
                        candidates.addAll((Collection<String>)this.options.get((Object)Shell.Command.CompletionSet.NAMESPACES));
                        prefix = (String)prefix + "-ns ";
                    } else if (current_command_token != null && (next = current_command_token.getSubcommand(current_string_token)) != null) {
                        current_command_token = next;
                        prefix = current_command_token.getCaseSensitive() ? (String)prefix + current_string_token + " " : (String)prefix + current_string_token.toUpperCase() + " ";
                        candidates.addAll(current_command_token.getSubcommandNames());
                    }
                    Collections.sort(candidates);
                    return ((String)prefix).length();
                }
                if (inTableFlag) {
                    for (String a : this.options.get((Object)Shell.Command.CompletionSet.TABLENAMES)) {
                        if (!a.startsWith(current_string_token)) continue;
                        candidates.add(a);
                    }
                } else if (inUserFlag) {
                    for (String a : this.options.get((Object)Shell.Command.CompletionSet.USERNAMES)) {
                        if (!a.startsWith(current_string_token)) continue;
                        candidates.add(a);
                    }
                } else if (inNamespaceFlag) {
                    for (String a : this.options.get((Object)Shell.Command.CompletionSet.NAMESPACES)) {
                        if (!a.startsWith(current_string_token)) continue;
                        candidates.add(a);
                    }
                } else if (current_command_token != null) {
                    candidates.addAll(current_command_token.getSubcommandNames(current_string_token));
                }
                Collections.sort(candidates);
                return ((String)prefix).length();
            }
            if (current_string_token.trim().equals("-t")) {
                inTableFlag = true;
            } else if (current_string_token.trim().equals("-u")) {
                inUserFlag = true;
            } else if (current_string_token.trim().equals("-ns")) {
                inNamespaceFlag = true;
            } else {
                inNamespaceFlag = false;
                inTableFlag = false;
                inUserFlag = false;
            }
            prefix = current_command_token != null && current_command_token.getCaseSensitive() ? (String)prefix + current_string_token + " " : (String)prefix + current_string_token.toUpperCase() + " ";
            if (current_command_token == null || !current_command_token.getSubcommandNames().contains(current_string_token)) continue;
            current_command_token = current_command_token.getSubcommand(current_string_token);
        }
        return 0;
    }
}

