/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TKey;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyValue;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTask
extends ScanTask<MultiScanResult> {
    private static final Logger log = LoggerFactory.getLogger(LookupTask.class);
    private final long scanID;

    public LookupTask(TabletHostingServer server, long scanID) {
        super(server);
        this.scanID = scanID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MultiScanSession session = (MultiScanSession)this.server.getSession(this.scanID);
        String oldThreadName = Thread.currentThread().getName();
        if (!this.transitionToRunning()) {
            return;
        }
        try {
            if (this.isCancelled() || session == null) {
                return;
            }
            TableConfiguration acuTableConf = this.server.getTableConfiguration(session.threadPoolExtent);
            long maxResultsSize = acuTableConf.getAsBytes(Property.TABLE_SCAN_MAXMEM);
            Thread.currentThread().setName("Client: " + session.client + " User: " + session.getUser() + " Start: " + session.startTime + " Table: ");
            long bytesAdded = 0L;
            long maxScanTime = 4000L;
            long startTime = System.currentTimeMillis();
            ArrayList<KVEntry> results = new ArrayList<KVEntry>();
            HashMap<KeyExtent, List<Range>> failures = new HashMap<KeyExtent, List<Range>>();
            ArrayList<KeyExtent> fullScans = new ArrayList<KeyExtent>();
            Tablet.LookupResult lookupResult = null;
            KeyExtent partScan = null;
            Key partNextKey = null;
            boolean partNextKeyInclusive = false;
            Iterator<Map.Entry<KeyExtent, List<Range>>> iter = session.queries.entrySet().iterator();
            while (iter.hasNext() && bytesAdded < maxResultsSize && System.currentTimeMillis() - startTime < maxScanTime) {
                Map.Entry<KeyExtent, List<Range>> entry = iter.next();
                KeyExtent extent = entry.getKey();
                List<Range> ranges = entry.getValue();
                iter.remove();
                TabletBase tablet = session.getTabletResolver().getTablet(extent);
                if (tablet == null) {
                    failures.put(extent, ranges);
                    continue;
                }
                Thread.currentThread().setName("Client: " + session.client + " User: " + session.getUser() + " Start: " + session.startTime + " Tablet: " + String.valueOf(extent));
                try {
                    if (this.isCancelled()) {
                        this.interruptFlag.set(true);
                    }
                    ArrayList<KVEntry> tabletResults = new ArrayList<KVEntry>();
                    lookupResult = tablet.lookup(ranges, tabletResults, session.scanParams, maxResultsSize - bytesAdded, this.interruptFlag);
                    results.addAll(tabletResults);
                    this.interruptFlag.set(false);
                }
                catch (IOException e) {
                    log.warn("lookup failed for tablet " + String.valueOf(extent), (Throwable)e);
                    throw new RuntimeException(e);
                }
                bytesAdded += lookupResult.bytesAdded;
                if (lookupResult.unfinishedRanges.isEmpty()) {
                    fullScans.add(extent);
                    continue;
                }
                if (lookupResult.closed) {
                    failures.put(extent, lookupResult.unfinishedRanges);
                    continue;
                }
                partScan = extent;
                partNextKey = lookupResult.unfinishedRanges.get(0).getStartKey();
                partNextKeyInclusive = lookupResult.unfinishedRanges.get(0).isStartKeyInclusive();
                break;
            }
            if (partScan != null) {
                session.queries.put(partScan, lookupResult.unfinishedRanges);
            }
            long finishTime = System.currentTimeMillis();
            session.totalLookupTime += finishTime - startTime;
            session.numEntries += results.size();
            boolean queriesIsEmpty = !session.queries.isEmpty();
            MultiScanResult multiScanResult = this.getMultiScanResult(results, partScan, failures, fullScans, partNextKey, partNextKeyInclusive, queriesIsEmpty);
            this.addResult(multiScanResult);
        }
        catch (IterationInterruptedException iie) {
            if (!this.isCancelled()) {
                log.warn("Iteration interrupted, when scan not cancelled", (Throwable)iie);
                this.addResult((Object)iie);
            }
        }
        catch (SampleNotPresentException e) {
            this.addResult((Object)e);
        }
        catch (Exception e) {
            log.warn("exception while doing multi-scan ", (Throwable)e);
            this.addResult(e);
        }
        finally {
            this.transitionFromRunning();
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private MultiScanResult getMultiScanResult(List<KVEntry> results, KeyExtent partScan, Map<KeyExtent, List<Range>> failures, List<KeyExtent> fullScans, Key partNextKey, boolean partNextKeyInclusive, boolean queriesIsEmpty) {
        List retResults = results.stream().map(entry -> new TKeyValue(((Key)entry.getKey()).toThrift(), ByteBuffer.wrap(((Value)entry.getValue()).get()))).collect(Collectors.toList());
        Map<TKeyExtent, List> retFailures = failures.entrySet().stream().collect(Collectors.toMap(entry -> ((KeyExtent)entry.getKey()).toThrift(), entry -> ((List)entry.getValue()).stream().map(Range::toThrift).collect(Collectors.toList())));
        List retFullScans = fullScans.stream().map(KeyExtent::toThrift).collect(Collectors.toList());
        TKeyExtent retPartScan = null;
        TKey retPartNextKey = null;
        if (partScan != null) {
            retPartScan = partScan.toThrift();
            retPartNextKey = partNextKey.toThrift();
        }
        return new MultiScanResult(retResults, retFailures, retFullScans, retPartScan, retPartNextKey, partNextKeyInclusive, queriesIsEmpty);
    }
}

