/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.CompressedIterators;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.TCMResult;
import org.apache.accumulo.core.dataImpl.thrift.TCMStatus;
import org.apache.accumulo.core.dataImpl.thrift.TCondition;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.IteratorBuilder;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironmentImpl;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;
import org.apache.hadoop.io.Text;

public class ConditionCheckerContext {
    private final CompressedIterators compressedIters;
    private final List<IterInfo> tableIters;
    private final Map<String, Map<String, String>> tableIterOpts;
    private final IteratorEnvironment ie;
    private final String context;
    private final Map<ByteSequence, MergedIterConfig> mergedIterCache = new HashMap<ByteSequence, MergedIterConfig>();

    ConditionCheckerContext(ServerContext context, CompressedIterators compressedIters, TableConfiguration tableConf) {
        this.compressedIters = compressedIters;
        TableConfiguration.ParsedIteratorConfig pic = tableConf.getParsedIteratorConfig(IteratorUtil.IteratorScope.scan);
        this.tableIters = pic.getIterInfo();
        this.tableIterOpts = pic.getOpts();
        this.context = pic.getServiceEnv();
        this.ie = new SystemIteratorEnvironmentImpl.Builder(context).withScope(IteratorUtil.IteratorScope.scan).withTableId(tableConf.getTableId()).build();
    }

    SortedKeyValueIterator<Key, Value> buildIterator(SortedKeyValueIterator<Key, Value> systemIter, TCondition tc) throws IOException, ReflectiveOperationException {
        ArrayByteSequence key = new ArrayByteSequence(tc.iterators);
        MergedIterConfig mic = this.mergedIterCache.get(key);
        if (mic == null) {
            CompressedIterators.IterConfig ic = this.compressedIters.decompress(tc.iterators);
            ArrayList<IterInfo> mergedIters = new ArrayList<IterInfo>(this.tableIters.size() + ic.ssiList.size());
            HashMap<String, Map<String, String>> mergedItersOpts = new HashMap<String, Map<String, String>>(this.tableIterOpts.size() + ic.ssio.size());
            IteratorConfigUtil.mergeIteratorConfig(mergedIters, mergedItersOpts, this.tableIters, this.tableIterOpts, (List)ic.ssiList, (Map)ic.ssio);
            mic = new MergedIterConfig(mergedIters, mergedItersOpts);
            this.mergedIterCache.put((ByteSequence)key, mic);
        }
        IteratorBuilder iteratorBuilder = IteratorBuilder.builder(mic.mergedIters).opts(mic.mergedItersOpts).env(this.ie).useClassLoader(this.context).useClassCache(true).build();
        return IteratorConfigUtil.loadIterators(systemIter, (IteratorBuilder)iteratorBuilder);
    }

    boolean checkConditions(SortedKeyValueIterator<Key, Value> systemIter, ServerConditionalMutation scm) throws IOException, ReflectiveOperationException {
        boolean add = true;
        for (TCondition tc : scm.getConditions()) {
            Range range = tc.hasTimestamp ? Range.exact((Text)new Text(scm.getRow()), (Text)new Text(tc.getCf()), (Text)new Text(tc.getCq()), (Text)new Text(tc.getCv()), (long)tc.getTs()) : Range.exact((Text)new Text(scm.getRow()), (Text)new Text(tc.getCf()), (Text)new Text(tc.getCq()), (Text)new Text(tc.getCv()));
            SortedKeyValueIterator<Key, Value> iter = this.buildIterator(systemIter, tc);
            ArrayByteSequence cf = new ArrayByteSequence(tc.getCf());
            iter.seek(range, Collections.singleton(cf), true);
            Value val = null;
            if (iter.hasTop()) {
                val = (Value)iter.getTopValue();
            }
            if (!(val == null ^ tc.getVal() == null) && (val == null || Arrays.equals(tc.getVal(), val.get()))) continue;
            add = false;
            break;
        }
        return add;
    }

    public ConditionChecker newChecker(List<ServerConditionalMutation> conditionsToCheck, List<ServerConditionalMutation> okMutations, List<TCMResult> results) {
        return new ConditionChecker(conditionsToCheck, okMutations, results);
    }

    private static class MergedIterConfig {
        List<IterInfo> mergedIters;
        Map<String, Map<String, String>> mergedItersOpts;

        MergedIterConfig(List<IterInfo> mergedIters, Map<String, Map<String, String>> mergedItersOpts) {
            this.mergedIters = mergedIters;
            this.mergedItersOpts = mergedItersOpts;
        }
    }

    public class ConditionChecker {
        private final List<ServerConditionalMutation> conditionsToCheck;
        private final List<ServerConditionalMutation> okMutations;
        private final List<TCMResult> results;
        private boolean checked = false;

        public ConditionChecker(List<ServerConditionalMutation> conditionsToCheck, List<ServerConditionalMutation> okMutations, List<TCMResult> results) {
            this.conditionsToCheck = conditionsToCheck;
            this.okMutations = okMutations;
            this.results = results;
        }

        public void check(SortedKeyValueIterator<Key, Value> systemIter) throws IOException, ReflectiveOperationException {
            Preconditions.checkArgument((!this.checked ? 1 : 0) != 0, (Object)"check() method should only be called once");
            this.checked = true;
            for (ServerConditionalMutation scm : this.conditionsToCheck) {
                if (ConditionCheckerContext.this.checkConditions(systemIter, scm)) {
                    this.okMutations.add(scm);
                    continue;
                }
                this.results.add(new TCMResult(scm.getID(), TCMStatus.REJECTED));
            }
        }
    }
}

