/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import com.google.common.cache.Cache;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.rfile.RFileSource;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.file.NoSuchMetaStoreException;
import org.apache.accumulo.core.file.blockfile.impl.BasicCacheProvider;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockDoesNotExist;
import org.apache.accumulo.core.logging.LoggingBlockCache;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheEntry;
import org.apache.accumulo.core.spi.cache.CacheType;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.summary.Gatherer;
import org.apache.accumulo.core.summary.SummarizerFactory;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.summary.SummarySerializer;
import org.apache.accumulo.core.summary.SummaryWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;

public class SummaryReader {
    private List<SummarySerializer> summaryStores;
    private SummarizerFactory factory;
    private boolean deleted;

    private static List<SummarySerializer> load(BlockReader bcReader, Predicate<SummarizerConfiguration> summarySelector) throws IOException {
        ArrayList<SummarySerializer> arrayList;
        block20: {
            DataInputStream in = bcReader.getMetaBlock("accumulo.summaries.index");
            try {
                ArrayList<SummarySerializer> stores = new ArrayList<SummarySerializer>();
                SummaryReader.readHeader(in);
                int numSummaries = WritableUtils.readVInt((DataInput)in);
                for (int i = 0; i < numSummaries; ++i) {
                    SummarizerConfiguration conf = SummaryReader.readConfig(in);
                    boolean inline = in.readBoolean();
                    if (inline) {
                        if (summarySelector.test(conf)) {
                            stores.add(SummarySerializer.load(conf, in));
                            continue;
                        }
                        SummarySerializer.skip(in);
                        continue;
                    }
                    int block = WritableUtils.readVInt((DataInput)in);
                    int offset = WritableUtils.readVInt((DataInput)in);
                    if (!summarySelector.test(conf)) continue;
                    try (DataInputStream summaryIn = bcReader.getMetaBlock("accumulo.summaries." + block);){
                        for (long skipped = in.skip(offset); skipped < (long)offset; skipped += in.skip((long)offset - skipped)) {
                        }
                        stores.add(SummarySerializer.load(conf, summaryIn));
                        continue;
                    }
                    catch (MetaBlockDoesNotExist e) {
                        throw new IOException(e);
                    }
                }
                arrayList = stores;
                if (in == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MetaBlockDoesNotExist e) {
                    return Collections.emptyList();
                }
            }
            in.close();
        }
        return arrayList;
    }

    private static SummaryReader load(CachableBlockFile.Reader bcReader, Predicate<SummarizerConfiguration> summarySelector, SummarizerFactory factory) throws IOException {
        SummaryReader fileSummaries = new SummaryReader();
        fileSummaries.summaryStores = SummaryReader.load(bcReader::getMetaBlock, summarySelector);
        fileSummaries.factory = factory;
        return fileSummaries;
    }

    public static SummaryReader load(Configuration conf, RFileSource source, String cacheId, Predicate<SummarizerConfiguration> summarySelector, SummarizerFactory factory, CryptoService cryptoService) throws IOException {
        CachableBlockFile.CachableBuilder cb = new CachableBlockFile.CachableBuilder().input(source.getInputStream(), cacheId).length(source.getLength()).conf(conf).cryptoService(cryptoService);
        return SummaryReader.load(new CachableBlockFile.Reader(cb), summarySelector, factory);
    }

    public static SummaryReader load(FileSystem fs, Configuration conf, SummarizerFactory factory, Path file, Predicate<SummarizerConfiguration> summarySelector, BlockCache summaryCache, BlockCache indexCache, Cache<String, Long> fileLenCache, CryptoService cryptoService) {
        CachableBlockFile.Reader bcReader = null;
        try {
            CompositeCache compositeCache = new CompositeCache(LoggingBlockCache.wrap(CacheType.SUMMARY, summaryCache), LoggingBlockCache.wrap(CacheType.INDEX, indexCache));
            CachableBlockFile.CachableBuilder cb = new CachableBlockFile.CachableBuilder().fsPath(fs, file).conf(conf).fileLen(fileLenCache).cacheProvider(new BasicCacheProvider(compositeCache, null)).cryptoService(cryptoService);
            bcReader = new CachableBlockFile.Reader(cb);
            SummaryReader summaryReader = SummaryReader.load(bcReader, summarySelector, factory);
            return summaryReader;
        }
        catch (FileNotFoundException fne) {
            SummaryReader summaryReader = SummaryReader.getEmptyReader(factory);
            return summaryReader;
        }
        catch (IOException e) {
            try {
                if (!fs.exists(file)) {
                    SummaryReader summaryReader = SummaryReader.getEmptyReader(factory);
                    return summaryReader;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new UncheckedIOException(e);
        }
        finally {
            if (bcReader != null) {
                try {
                    bcReader.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private static SummaryReader getEmptyReader(SummarizerFactory factory) {
        SummaryReader sr = new SummaryReader();
        sr.factory = factory;
        sr.summaryStores = Collections.emptyList();
        sr.deleted = true;
        return sr;
    }

    public static void print(RFile.Reader iter, PrintStream out) throws IOException {
        List<SummarySerializer> stores = null;
        try {
            stores = SummaryReader.load(iter::getMetaStore, conf -> true);
        }
        catch (NoSuchMetaStoreException e) {
            out.print("No summary data present in file\n");
            return;
        }
        String indent = "   ";
        out.print("Summary data : \n");
        int i = 1;
        for (SummarySerializer summaryStore : stores) {
            out.printf("%sSummary %d of %d generated by : %s\n", indent, i, stores.size(), summaryStore.getSummarizerConfiguration());
            ++i;
            summaryStore.print(indent, indent, out);
        }
    }

    private static SummarizerConfiguration readConfig(DataInputStream in) throws IOException {
        String summarizerClazz = in.readUTF();
        String configId = in.readUTF();
        SummarizerConfiguration.Builder scb = SummarizerConfiguration.builder(summarizerClazz).setPropertyId(configId);
        int numOpts = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < numOpts; ++i) {
            String k = in.readUTF();
            String v = in.readUTF();
            scb.addOption(k, v);
        }
        return scb.build();
    }

    private static byte readHeader(DataInputStream in) throws IOException {
        long magic = in.readLong();
        if (magic != SummaryWriter.MAGIC) {
            throw new IOException("Bad magic : " + String.format("%x", magic));
        }
        byte ver = in.readByte();
        if (ver != SummaryWriter.VER) {
            throw new IOException("Unknown version : " + ver);
        }
        return ver;
    }

    public SummaryCollection getSummaries(List<Gatherer.RowRange> ranges) {
        ArrayList<SummaryCollection.FileSummary> initial = new ArrayList<SummaryCollection.FileSummary>();
        if (this.deleted) {
            return new SummaryCollection(initial, true);
        }
        for (SummarySerializer summaryStore : this.summaryStores) {
            if (summaryStore.exceededMaxSize()) {
                initial.add(new SummaryCollection.FileSummary(summaryStore.getSummarizerConfiguration()));
                continue;
            }
            Map<String, Long> summary = summaryStore.getSummary(ranges, this.factory);
            boolean exceeded = summaryStore.exceedsRange(ranges);
            initial.add(new SummaryCollection.FileSummary(summaryStore.getSummarizerConfiguration(), summary, exceeded));
        }
        return new SummaryCollection(initial);
    }

    private static interface BlockReader {
        public DataInputStream getMetaBlock(String var1) throws IOException;
    }

    private static class CompositeCache
    implements BlockCache {
        private final BlockCache summaryCache;
        private final BlockCache indexCache;

        CompositeCache(BlockCache summaryCache, BlockCache indexCache) {
            this.summaryCache = summaryCache;
            this.indexCache = indexCache;
        }

        @Override
        public CacheEntry cacheBlock(String blockName, byte[] buf) {
            return this.summaryCache.cacheBlock(blockName, buf);
        }

        @Override
        public CacheEntry getBlock(String blockName) {
            CacheEntry ce = this.summaryCache.getBlock(blockName);
            if (ce == null) {
                ce = this.indexCache.getBlock(blockName);
            }
            return ce;
        }

        @Override
        public CacheEntry getBlock(final String blockName, final BlockCache.Loader loader) {
            BlockCache.Loader idxLoader = new BlockCache.Loader(){
                CacheEntry idxCacheEntry;

                @Override
                public Map<String, BlockCache.Loader> getDependencies() {
                    this.idxCacheEntry = indexCache.getBlock(blockName);
                    if (this.idxCacheEntry == null) {
                        return loader.getDependencies();
                    }
                    return Collections.emptyMap();
                }

                @Override
                public byte[] load(int maxSize, Map<String, byte[]> dependencies) {
                    if (this.idxCacheEntry == null) {
                        return loader.load(maxSize, dependencies);
                    }
                    return this.idxCacheEntry.getBuffer();
                }
            };
            return this.summaryCache.getBlock(blockName, idxLoader);
        }

        @Override
        public long getMaxSize() {
            return this.summaryCache.getMaxSize();
        }

        @Override
        public BlockCache.Stats getStats() {
            return this.summaryCache.getStats();
        }

        @Override
        public long getMaxHeapSize() {
            return this.summaryCache.getMaxHeapSize();
        }
    }
}

