/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.crypto;

import java.util.Map;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;

public class GenericCryptoServiceFactory
implements CryptoServiceFactory {
    public static final String GENERAL_SERVICE_NAME_PROP = String.valueOf((Object)Property.GENERAL_ARBITRARY_PROP_PREFIX) + "crypto.service";
    public static final String TABLE_SERVICE_NAME_PROP = String.valueOf((Object)Property.TABLE_CRYPTO_PREFIX) + "service";

    @Override
    public CryptoService getService(CryptoEnvironment environment, Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return NoCryptoServiceFactory.NONE;
        }
        String cryptoServiceName = properties.get(GENERAL_SERVICE_NAME_PROP);
        if (cryptoServiceName == null && (cryptoServiceName = properties.get(TABLE_SERVICE_NAME_PROP)) == null) {
            return NoCryptoServiceFactory.NONE;
        }
        CryptoService cs = this.newCryptoService(cryptoServiceName);
        cs.init(properties);
        return cs;
    }
}

