/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class ColumnFamilyCounter
implements SortedKeyValueIterator<Key, Value> {
    private SortedKeyValueIterator<Key, Value> source;
    private Key key;
    private Value value;

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = source;
    }

    @Override
    public boolean hasTop() {
        return this.key != null;
    }

    @Override
    public void next() throws IOException {
        if (this.source.hasTop()) {
            ByteSequence currentRow = this.source.getTopKey().getRowData();
            ByteSequence currentColf = this.source.getTopKey().getColumnFamilyData();
            long ts = this.source.getTopKey().getTimestamp();
            this.source.next();
            int count = 1;
            while (this.source.hasTop() && this.source.getTopKey().getRowData().equals(currentRow) && this.source.getTopKey().getColumnFamilyData().equals(currentColf)) {
                ++count;
                this.source.next();
            }
            this.key = new Key(currentRow.toArray(), currentColf.toArray(), new byte[0], new byte[0], ts);
            this.value = new Value(Integer.toString(count));
        } else {
            this.key = null;
            this.value = null;
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.next();
    }

    @Override
    public Key getTopKey() {
        return this.key;
    }

    @Override
    public Value getTopValue() {
        return this.value;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return null;
    }
}

