/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.apache.accumulo.core.spi.cache.CacheType;

public class BlockCacheConfiguration
implements BlockCacheManager.Configuration {
    private final long blockSize;
    private final Property serverPrefix;
    private final Map<String, String> genProps;
    private final long indexMaxSize;
    private final long dataMaxSize;
    private final long summaryMaxSize;

    public static BlockCacheConfiguration forTabletServer(AccumuloConfiguration conf) {
        return new BlockCacheConfiguration(conf, Property.TSERV_PREFIX, Property.TSERV_INDEXCACHE_SIZE, Property.TSERV_DATACACHE_SIZE, Property.TSERV_SUMMARYCACHE_SIZE, Property.TSERV_DEFAULT_BLOCKSIZE);
    }

    public static BlockCacheConfiguration forScanServer(AccumuloConfiguration conf) {
        return new BlockCacheConfiguration(conf, Property.SSERV_PREFIX, Property.SSERV_INDEXCACHE_SIZE, Property.SSERV_DATACACHE_SIZE, Property.SSERV_SUMMARYCACHE_SIZE, Property.SSERV_DEFAULT_BLOCKSIZE);
    }

    private BlockCacheConfiguration(AccumuloConfiguration conf, Property serverPrefix, Property indexCacheSizeProperty, Property dataCacheSizeProperty, Property summaryCacheSizeProperty, Property defaultBlockSizeProperty) {
        this.serverPrefix = serverPrefix;
        this.genProps = conf.getAllPropertiesWithPrefix(serverPrefix);
        this.indexMaxSize = conf.getAsBytes(indexCacheSizeProperty);
        this.dataMaxSize = conf.getAsBytes(dataCacheSizeProperty);
        this.summaryMaxSize = conf.getAsBytes(summaryCacheSizeProperty);
        this.blockSize = conf.getAsBytes(defaultBlockSizeProperty);
    }

    @Override
    public long getMaxSize(CacheType type) {
        switch (type) {
            case INDEX: {
                return this.indexMaxSize;
            }
            case DATA: {
                return this.dataMaxSize;
            }
            case SUMMARY: {
                return this.summaryMaxSize;
            }
        }
        throw new IllegalArgumentException("Unknown block cache type");
    }

    @Override
    public long getBlockSize() {
        return this.blockSize;
    }

    public String toString() {
        return "indexMaxSize: " + this.indexMaxSize + "dataMaxSize: " + this.dataMaxSize + "summaryMaxSize: " + this.summaryMaxSize + ", blockSize: " + this.getBlockSize();
    }

    @Override
    public Map<String, String> getProperties(String prefix, CacheType type) {
        HashMap props = new HashMap();
        String defaultPrefix = BlockCacheConfiguration.getFullyQualifiedPropertyPrefix(this.serverPrefix, prefix);
        this.genProps.forEach((k, v) -> {
            if (k.startsWith(defaultPrefix)) {
                props.put(k.substring(defaultPrefix.length()), v);
            }
        });
        String typePrefix = BlockCacheConfiguration.getFullyQualifiedPropertyPrefix(this.serverPrefix, prefix, type);
        this.genProps.forEach((k, v) -> {
            if (k.startsWith(typePrefix)) {
                props.put(k.substring(typePrefix.length()), v);
            }
        });
        return Collections.unmodifiableMap(props);
    }

    public static String getFullyQualifiedPropertyPrefix(Property serverPrefix, String prefix) {
        return BlockCacheConfiguration.getCachePropertyBase(serverPrefix) + prefix + ".default.";
    }

    public static String getFullyQualifiedPropertyPrefix(Property serverPrefix, String prefix, CacheType type) {
        return BlockCacheConfiguration.getCachePropertyBase(serverPrefix) + prefix + "." + type.name().toLowerCase() + ".";
    }

    public static String getCachePropertyBase(Property serverPrefix) {
        return serverPrefix.getKey() + "cache.config.";
    }
}

