/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf.cluster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class ClusterConfigParser {
    private static final Pattern GROUP_NAME_PATTERN = Pattern.compile("^[a-zA-Z_]{1,}[a-zA-Z0-9_]{0,}$");
    private static final String PROPERTY_FORMAT = "%s=\"%s\"%n";
    private static final String[] SECTIONS = new String[]{"manager", "monitor", "gc", "tserver"};
    private static final Set<String> VALID_CONFIG_KEYS = Set.of("manager", "monitor", "gc", "tserver", "tservers_per_host", "compaction.coordinator");
    private static final Set<String> VALID_CONFIG_PREFIXES = Set.of("compaction.compactor.", "sserver.", "compactors_per_host.", "sservers_per_host.");
    private static final Predicate<String> VALID_CONFIG_SECTIONS = section -> {
        if (VALID_CONFIG_KEYS.contains(section)) return true;
        if (!VALID_CONFIG_PREFIXES.stream().anyMatch(section::startsWith)) return false;
        return true;
    };

    public static void validateGroupNames(Set<String> names) {
        for (String name : names) {
            if (GROUP_NAME_PATTERN.matcher(name).matches()) continue;
            throw new RuntimeException("Group name: " + name + " contains invalid characters");
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="paths not set by user input")
    public static Map<String, String> parseConfiguration(String configFile) throws IOException {
        HashMap<String, String> results = new HashMap<String, String>();
        try (InputStream fis = Files.newInputStream(Paths.get(configFile, new String[0]), StandardOpenOption.READ);){
            Yaml y = new Yaml();
            Map config = (Map)y.load(fis);
            config.forEach((k, v) -> ClusterConfigParser.flatten("", k, v, results));
        }
        return results;
    }

    private static String addTheDot(String key) {
        return key.endsWith(".") ? "" : ".";
    }

    private static void flatten(String parentKey, String key, Object value, Map<String, String> results) {
        String parent;
        String string = parent = parentKey == null || parentKey.equals("") ? "" : parentKey + ClusterConfigParser.addTheDot(parentKey);
        if (value instanceof String) {
            results.put(parent + key, (String)value);
        } else if (value instanceof List) {
            ((List)value).forEach(l -> {
                if (l instanceof String) {
                    String val = value.toString();
                    results.put(parent + key, val.substring(1, val.length() - 1).replace(", ", " "));
                } else {
                    ClusterConfigParser.flatten(parent, key, l, results);
                }
            });
        } else if (value instanceof Map) {
            Map map = (Map)value;
            map.forEach((k, v) -> ClusterConfigParser.flatten(parent + key, k, v, results));
        } else if (value instanceof Number) {
            results.put(parent + key, value.toString());
        } else {
            throw new IllegalStateException("Unhandled object type: " + String.valueOf(value.getClass()));
        }
    }

    public static void outputShellVariables(Map<String, String> config, PrintStream out) {
        config.keySet().stream().filter(VALID_CONFIG_SECTIONS.negate()).findFirst().ifPresent(section -> {
            throw new IllegalArgumentException("Unknown configuration section : " + section);
        });
        for (String section2 : SECTIONS) {
            if (config.containsKey(section2)) {
                out.printf(PROPERTY_FORMAT, section2.toUpperCase() + "_HOSTS", config.get(section2));
                continue;
            }
            if (section2.equals("manager") || section2.equals("tserver")) {
                throw new IllegalStateException("Required configuration section is missing: " + section2);
            }
            System.err.println("WARN: " + section2 + " is missing");
        }
        if (config.containsKey("compaction.coordinator")) {
            out.printf(PROPERTY_FORMAT, "COORDINATOR_HOSTS", config.get("compaction.coordinator"));
        }
        String compactorPrefix = "compaction.compactor.";
        Set<String> compactorQueues = config.keySet().stream().filter(k -> k.startsWith(compactorPrefix)).map(k -> k.substring(compactorPrefix.length())).collect(Collectors.toSet());
        ClusterConfigParser.validateGroupNames(compactorQueues);
        if (!compactorQueues.isEmpty()) {
            out.printf(PROPERTY_FORMAT, "COMPACTION_QUEUES", compactorQueues.stream().collect(Collectors.joining(" ")));
            for (String queue : compactorQueues) {
                out.printf(PROPERTY_FORMAT, "COMPACTOR_HOSTS_" + queue, config.get("compaction.compactor." + queue));
                String numCompactors = config.getOrDefault("compactors_per_host." + queue, "1");
                out.printf(PROPERTY_FORMAT, "NUM_COMPACTORS_" + queue, numCompactors);
            }
        }
        String sserverPrefix = "sserver.";
        Set<String> sserverGroups = config.keySet().stream().filter(k -> k.startsWith(sserverPrefix)).map(k -> k.substring(sserverPrefix.length())).collect(Collectors.toSet());
        ClusterConfigParser.validateGroupNames(sserverGroups);
        if (!sserverGroups.isEmpty()) {
            out.printf(PROPERTY_FORMAT, "SSERVER_GROUPS", sserverGroups.stream().collect(Collectors.joining(" ")));
            sserverGroups.forEach(ssg -> out.printf(PROPERTY_FORMAT, "SSERVER_HOSTS_" + ssg, config.get(sserverPrefix + ssg)));
            sserverGroups.forEach(ssg -> out.printf(PROPERTY_FORMAT, "NUM_SSERVERS_" + ssg, config.getOrDefault("sservers_per_host." + ssg, "1")));
        }
        String numTservers = config.getOrDefault("tservers_per_host", "1");
        out.print("NUM_TSERVERS=\"${NUM_TSERVERS:=" + numTservers + "}\"\n");
        out.flush();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path provided for output file is intentional")
    public static void main(String[] args) throws IOException {
        block15: {
            if (args == null || args.length < 1 || args.length > 2) {
                System.err.println("Usage: ClusterConfigParser <configFile> [<outputFile>]");
                System.exit(1);
            }
            try {
                if (args.length == 2) {
                    try (OutputStream os = Files.newOutputStream(Paths.get(args[1], new String[0]), StandardOpenOption.CREATE);
                         PrintStream out = new PrintStream(os);){
                        ClusterConfigParser.outputShellVariables(ClusterConfigParser.parseConfiguration(args[0]), new PrintStream(out));
                        break block15;
                    }
                }
                ClusterConfigParser.outputShellVariables(ClusterConfigParser.parseConfiguration(args[0]), System.out);
            }
            catch (Exception e) {
                System.err.println("Processing error: " + e.getMessage());
                System.exit(1);
            }
        }
    }
}

