/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.classloader;

import java.io.IOException;
import org.apache.accumulo.core.classloader.DefaultContextClassLoaderFactory;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.common.ContextClassLoaderFactory;
import org.apache.accumulo.core.util.ConfigurationImpl;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderUtil.class);
    private static ContextClassLoaderFactory FACTORY;

    private ClassLoaderUtil() {
    }

    public static synchronized void initContextFactory(AccumuloConfiguration conf) {
        if (FACTORY == null) {
            LOG.debug("Creating {}", (Object)ContextClassLoaderFactory.class.getName());
            String factoryName = conf.get(Property.GENERAL_CONTEXT_CLASSLOADER_FACTORY);
            if (factoryName == null || factoryName.isEmpty()) {
                LOG.info("Using default {}, which is subject to change in a future release", (Object)ContextClassLoaderFactory.class.getName());
                FACTORY = new DefaultContextClassLoaderFactory(conf);
            } else {
                try {
                    Class<ContextClassLoaderFactory> factoryClass = Class.forName(factoryName).asSubclass(ContextClassLoaderFactory.class);
                    LOG.info("Creating {}: {}", (Object)ContextClassLoaderFactory.class.getName(), (Object)factoryName);
                    FACTORY = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    FACTORY.init(() -> new ConfigurationImpl(conf));
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Unable to load and initialize class: " + factoryName, e);
                }
            }
        } else {
            LOG.debug("{} already initialized with {}.", (Object)ContextClassLoaderFactory.class.getName(), (Object)FACTORY.getClass().getName());
        }
    }

    static ContextClassLoaderFactory getContextFactory() {
        return FACTORY;
    }

    public static synchronized void resetContextFactoryForTests() {
        FACTORY = null;
    }

    public static ClassLoader getClassLoader(String context) throws ContextClassLoaderFactory.ContextClassLoaderException {
        if (context != null && !context.isEmpty()) {
            return FACTORY.getClassLoader(context);
        }
        try {
            return AccumuloVFSClassLoader.getClassLoader();
        }
        catch (IOException e) {
            throw new ContextClassLoaderFactory.ContextClassLoaderException(context, e);
        }
    }

    public static boolean isValidContext(String context) {
        if (context != null && !context.isEmpty()) {
            try {
                ClassLoader loader = FACTORY.getClassLoader(context);
                if (loader == null) {
                    LOG.debug("Context {} resulted in a null classloader from {}.", (Object)context, (Object)FACTORY.getClass().getName());
                    return false;
                }
                return true;
            }
            catch (ContextClassLoaderFactory.ContextClassLoaderException e) {
                LOG.debug("Context {} is not valid.", (Object)context, (Object)e);
                return false;
            }
        }
        return true;
    }

    public static <U> Class<? extends U> loadClass(String context, String className, Class<U> extension) throws ClassNotFoundException {
        try {
            return ClassLoaderUtil.getClassLoader(context).loadClass(className).asSubclass(extension);
        }
        catch (ContextClassLoaderFactory.ContextClassLoaderException e) {
            throw new ClassNotFoundException("Error loading class from context: " + context, e);
        }
    }

    public static <U> Class<? extends U> loadClass(String className, Class<U> extension) throws ClassNotFoundException {
        return ClassLoaderUtil.loadClass(null, className, extension);
    }

    public static String tableContext(AccumuloConfiguration conf) {
        return conf.get(conf.resolve(Property.TABLE_CLASSLOADER_CONTEXT, Property.TABLE_CLASSPATH));
    }
}

