/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;

public class UnassignedTablet {
    private final TabletMetadata.Location location;
    private final TabletMetadata.Location lastLocation;

    public UnassignedTablet(TabletMetadata.Location location, TabletMetadata.Location lastLocation) {
        Preconditions.checkArgument((lastLocation == null || lastLocation.getType() == TabletMetadata.LocationType.LAST ? 1 : 0) != 0);
        this.location = location;
        this.lastLocation = lastLocation;
    }

    public TabletMetadata.Location getLocation() {
        return this.location;
    }

    public TabletMetadata.Location getLastLocation() {
        return this.lastLocation;
    }

    public TServerInstance getServerInstance() {
        return this.location != null ? this.location.getServerInstance() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnassignedTablet that = (UnassignedTablet)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.lastLocation, that.lastLocation);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.lastLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("UnassignedTablet [").append("location:");
        if (this.location != null) {
            sb.append(this.location.getType()).append("=").append(this.location.getServerInstance());
        }
        sb.append(", lastLocation:");
        if (this.lastLocation != null) {
            sb.append(this.lastLocation.getType()).append("=").append(this.lastLocation.getServerInstance());
        }
        sb.append("]");
        return sb.toString();
    }
}

