/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import java.util.HashMap;
import java.util.HashSet;

public enum TabletServerState {
    RESERVED(-1),
    NEW(0),
    ONLINE(1),
    UNRESPONSIVE(2),
    DOWN(3),
    BAD_SYSTEM_PASSWORD(101),
    BAD_VERSION(102),
    BAD_INSTANCE(103),
    BAD_CONFIG(104),
    BAD_VERSION_AND_INSTANCE(105),
    BAD_VERSION_AND_CONFIG(106),
    BAD_VERSION_AND_INSTANCE_AND_CONFIG(107),
    BAD_INSTANCE_AND_CONFIG(108);

    private final byte id;
    private static final HashMap<Byte, TabletServerState> mapping;
    private static final HashSet<TabletServerState> badStates;

    private TabletServerState(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static TabletServerState getStateById(byte id) {
        if (mapping.containsKey(id)) {
            return mapping.get(id);
        }
        throw new IndexOutOfBoundsException("No such state");
    }

    static {
        mapping = new HashMap(TabletServerState.values().length);
        badStates = new HashSet();
        for (TabletServerState state : TabletServerState.values()) {
            mapping.put(state.id, state);
            if (state.id <= 99) continue;
            badStates.add(state);
        }
    }
}

