/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.codec;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VersionedProperties {
    public static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
    private static final int INIT_VERSION = 0;
    private final long dataVersion;
    private final Instant timestamp;
    private final Map<String, String> props;

    public VersionedProperties() {
        this(Map.of());
    }

    public VersionedProperties(Map<String, String> props) {
        this(0L, Instant.now(), props);
    }

    public VersionedProperties(long zkDataVersion, Instant timestamp, Map<String, String> props) {
        this.dataVersion = zkDataVersion & 0xFFFFFFFFL;
        this.timestamp = Objects.requireNonNull(timestamp, "A timestamp must be supplied");
        this.props = props == null ? Map.of() : Map.copyOf(props);
    }

    public @NonNull Map<String, String> asMap() {
        return this.props;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampISO() {
        return TIMESTAMP_FORMATTER.format(this.timestamp);
    }

    public VersionedProperties addOrUpdate(String key, String value) {
        HashMap<String, String> updated = new HashMap<String, String>(this.props);
        updated.put(key, value);
        return new VersionedProperties(this.dataVersion, Instant.now(), updated);
    }

    public VersionedProperties addOrUpdate(Map<String, String> updates) {
        HashMap<String, String> updated = new HashMap<String, String>(this.props);
        updated.putAll(updates);
        return new VersionedProperties(this.dataVersion, Instant.now(), updated);
    }

    public VersionedProperties replaceAll(Map<String, String> updates) {
        return new VersionedProperties(this.dataVersion, Instant.now(), updates);
    }

    public VersionedProperties remove(Collection<String> keys) {
        HashMap<String, String> updated = new HashMap<String, String>(this.props);
        updated.keySet().removeAll(keys);
        return new VersionedProperties(this.dataVersion, Instant.now(), updated);
    }

    public String print(boolean prettyPrint) {
        StringBuilder sb = new StringBuilder();
        sb.append("dataVersion=").append(this.dataVersion).append(prettyPrint ? "\n" : ", ");
        sb.append("timeStamp=").append(TIMESTAMP_FORMATTER.format(this.timestamp)).append(prettyPrint ? "\n" : ", ");
        TreeMap<String, String> sorted = new TreeMap<String, String>(this.props);
        sorted.forEach((k, v) -> {
            if (prettyPrint) {
                sb.append("  ");
            }
            sb.append((String)k).append("=").append((String)v);
            sb.append(prettyPrint ? "\n" : ", ");
        });
        return sb.toString();
    }

    public String toString() {
        return this.print(false);
    }
}

