/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.util.PropSnapshot;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public class ZooBasedConfiguration
extends AccumuloConfiguration {
    protected final Logger log;
    private final AccumuloConfiguration parent;
    private final PropStoreKey<?> propStoreKey;
    private final PropSnapshot propSnapshot;

    public ZooBasedConfiguration(Logger log, ServerContext context, PropStoreKey<?> propStoreKey, AccumuloConfiguration parent) {
        this.log = Objects.requireNonNull(log, "a Logger must be supplied");
        Objects.requireNonNull(context, "the context cannot be null");
        this.propStoreKey = Objects.requireNonNull(propStoreKey, "a PropCacheId must be supplied");
        this.parent = Objects.requireNonNull(parent, "An AccumuloConfiguration parent must be supplied");
        this.propSnapshot = PropSnapshot.create(propStoreKey, context.getPropStore());
    }

    @VisibleForTesting
    public void zkChangeEvent(PropStoreKey<?> propStoreKey) {
        this.propSnapshot.zkChangeEvent(propStoreKey);
    }

    public long getDataVersion() {
        return this.propSnapshot.getVersionedProperties().getDataVersion();
    }

    public long getUpdateCount() {
        long count = 0L;
        long dataVersion = 0L;
        for (ZooBasedConfiguration p = this; p != null; p = p.getParent()) {
            dataVersion = p instanceof ZooBasedConfiguration ? p.getDataVersion() : p.getUpdateCount();
            count += dataVersion;
        }
        this.log.trace("update count result for: {} - data version: {} update: {}", new Object[]{this.propStoreKey, dataVersion, count});
        return count;
    }

    public AccumuloConfiguration getParent() {
        return this.parent;
    }

    public PropStoreKey<?> getPropStoreKey() {
        return this.propStoreKey;
    }

    public @Nullable String get(Property property) {
        Map<String, String> props = this.getSnapshot();
        String value = props.get(property.getKey());
        if (value != null) {
            return value;
        }
        AccumuloConfiguration parent = this.getParent();
        if (parent != null) {
            return parent.get(property);
        }
        return null;
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.parent.getProperties(props, filter);
        Map<String, String> theseProps = this.getSnapshot();
        this.log.trace("getProperties() for: {} filter: {}, have: {}, passed: {}", new Object[]{this.getPropStoreKey(), filter, theseProps, props});
        for (Map.Entry<String, String> p : theseProps.entrySet()) {
            if (!filter.test(p.getKey()) || p.getValue() == null) continue;
            this.log.trace("passed filter - add to map: {} = {}", (Object)p.getKey(), (Object)p.getValue());
            props.put(p.getKey(), p.getValue());
        }
    }

    public boolean isPropertySet(Property property) {
        return this.getSnapshot().get(property.getKey()) != null || this.getParent().isPropertySet(property);
    }

    public @NonNull Map<String, String> getSnapshot() {
        return this.propSnapshot.getVersionedProperties().asMap();
    }

    public void invalidateCache() {
        this.propSnapshot.requireUpdate();
    }
}

